"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getViewLinkStatus = getViewLinkStatus;
var _i18n = require("@kbn/i18n");
var _analytics = require("../../../../common/analytics");
var _common = require("../analytics_list/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const unknownJobTypeMessage = _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.viewActionUnknownJobTypeToolTipContent', {
  defaultMessage: 'There is no results page available for this type of data frame analytics job.'
});
const jobNotStartedMessage = _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.viewActionJobNotStartedToolTipContent', {
  defaultMessage: 'The data frame analytics job did not start. There is no results page available.'
});
const jobNotFinishedMessage = _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.viewActionJobNotFinishedToolTipContent', {
  defaultMessage: 'The data frame analytics job is not finished. There is no results page available.'
});
const jobFailedMessage = _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.viewActionJobFailedToolTipContent', {
  defaultMessage: 'The data frame analytics job failed. There is no results page available.'
});
function getViewLinkStatus(item) {
  const viewLinkStatus = {
    disabled: false
  };
  const progressStats = (0, _common.getDataFrameAnalyticsProgressPhase)(item.stats);
  const jobFailed = (0, _common.isDataFrameAnalyticsFailed)(item.stats.state);
  const jobNotStarted = progressStats.currentPhase === 1 && progressStats.progress === 0;
  const jobFinished = (0, _common.isDataFrameAnalyticsStopped)(item.stats.state) && progressStats.currentPhase === progressStats.totalPhases && progressStats.progress === 100;
  const isUnknownJobType = !(0, _analytics.isRegressionAnalysis)(item.config.analysis) && !(0, _analytics.isOutlierAnalysis)(item.config.analysis) && !(0, _analytics.isClassificationAnalysis)(item.config.analysis);
  const disabled = !jobFinished || jobFailed || isUnknownJobType;
  if (disabled) {
    viewLinkStatus.disabled = true;
    if (isUnknownJobType) {
      viewLinkStatus.tooltipContent = unknownJobTypeMessage;
    } else if (jobFailed) {
      viewLinkStatus.tooltipContent = jobFailedMessage;
    } else if (jobNotStarted) {
      viewLinkStatus.tooltipContent = jobNotStartedMessage;
    } else if (!jobFinished) {
      viewLinkStatus.tooltipContent = jobNotFinishedMessage;
    }
  }
  return viewLinkStatus;
}