"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStartAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _common = require("../analytics_list/common");
var _analytics_service = require("../../services/analytics_service");
var _toast_notification_service = require("../../../../../services/toast_notification_service");
var _start_action_name = require("./start_action_name");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStartAction = canStartStopDataFrameAnalytics => {
  const [isModalVisible, setModalVisible] = (0, _react.useState)(false);
  const [item, setItem] = (0, _react.useState)();
  const toastNotificationService = (0, _toast_notification_service.useToastNotificationService)();
  const closeModal = () => setModalVisible(false);
  const startAndCloseModal = () => {
    if (item !== undefined) {
      setModalVisible(false);
      (0, _analytics_service.startAnalytics)(item, toastNotificationService);
    }
  };
  const openModal = newItem => {
    setItem(newItem);
    setModalVisible(true);
  };
  const startButtonEnabled = i => {
    if (!(0, _common.isDataFrameAnalyticsRunning)(i.stats.state)) {
      // Disable start for analytics jobs which have completed.
      const completeAnalytics = (0, _common.isCompletedAnalyticsJob)(i.stats);
      return canStartStopDataFrameAnalytics && !completeAnalytics;
    }
    return canStartStopDataFrameAnalytics;
  };
  const action = (0, _react.useMemo)(() => ({
    name: i => /*#__PURE__*/_react.default.createElement(_start_action_name.StartActionName, {
      isDisabled: !startButtonEnabled(i),
      item: i,
      canStartStopDataFrameAnalytics: canStartStopDataFrameAnalytics
    }),
    available: i => !(0, _common.isDataFrameAnalyticsRunning)(i.stats.state) && !(0, _common.isDataFrameAnalyticsFailed)(i.stats.state),
    enabled: startButtonEnabled,
    description: _start_action_name.startActionNameText,
    icon: 'play',
    type: 'icon',
    onClick: openModal,
    'data-test-subj': 'mlAnalyticsJobStartButton'
  }),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  return {
    action,
    closeModal,
    isModalVisible,
    item,
    openModal,
    startAndCloseModal
  };
};
exports.useStartAction = useStartAction;