"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapActionButtonText = exports.MapButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _analytics = require("../../../../common/analytics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapActionButtonText = _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.mapActionName', {
  defaultMessage: 'Map'
});
exports.mapActionButtonText = mapActionButtonText;
const MapButton = ({
  item
}) => {
  const disabled = !(0, _analytics.isRegressionAnalysis)(item.config.analysis) && !(0, _analytics.isOutlierAnalysis)(item.config.analysis) && !(0, _analytics.isClassificationAnalysis)(item.config.analysis);
  if (disabled) {
    const toolTipContent = _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.mapActionDisabledTooltipContent', {
      defaultMessage: 'Unknown analysis type.'
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: toolTipContent
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, mapActionButtonText));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, mapActionButtonText);
};
exports.MapButton = MapButton;