"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEditAction = exports.isEditActionFlyoutVisible = void 0;
var _react = _interopRequireWildcard(require("react"));
var _edit_action_name = require("./edit_action_name");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isEditActionFlyoutVisible = editAction => {
  return editAction.isFlyoutVisible === true && editAction.item !== undefined;
};
exports.isEditActionFlyoutVisible = isEditActionFlyoutVisible;
const useEditAction = canStartStopDataFrameAnalytics => {
  const [item, setItem] = (0, _react.useState)();
  const [isFlyoutVisible, setIsFlyoutVisible] = (0, _react.useState)(false);
  const closeFlyout = () => setIsFlyoutVisible(false);
  const openFlyout = newItem => {
    setItem(newItem);
    setIsFlyoutVisible(true);
  };
  const action = (0, _react.useMemo)(() => ({
    name: () => /*#__PURE__*/_react.default.createElement(_edit_action_name.EditActionName, {
      isDisabled: !canStartStopDataFrameAnalytics
    }),
    enabled: () => canStartStopDataFrameAnalytics,
    description: _edit_action_name.editActionNameText,
    icon: 'pencil',
    type: 'icon',
    onClick: i => openFlyout(i),
    'data-test-subj': 'mlAnalyticsJobEditButton'
  }), [canStartStopDataFrameAnalytics]);
  return {
    action,
    isFlyoutVisible,
    item,
    closeFlyout,
    openFlyout
  };
};
exports.useEditAction = useEditAction;