"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Page = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _mlUrlState = require("@kbn/ml-url-state");
var _outlier_exploration = require("./components/outlier_exploration");
var _regression_exploration = require("./components/regression_exploration");
var _classification_exploration = require("./components/classification_exploration");
var _data_frame_analytics = require("../../../../../common/constants/data_frame_analytics");
var _help_menu = require("../../../components/help_menu");
var _kibana = require("../../../contexts/kibana");
var _page_header = require("../../../components/page_header");
var _analytics_selector = require("../components/analytics_selector");
var _empty_prompt = require("../analytics_management/components/empty_prompt");
var _saved_objects_warning = require("../../../components/saved_objects_warning");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Page = ({
  jobId,
  analysisType
}) => {
  const [analyticsId, setAnalyticsId] = (0, _react.useState)();
  const [isIdSelectorFlyoutVisible, setIsIdSelectorFlyoutVisible] = (0, _react.useState)(!jobId);
  const [jobsExist, setJobsExist] = (0, _react.useState)(true);
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const {
    dataFrameAnalytics: {
      getDataFrameAnalytics
    }
  } = (0, _kibana.useMlApiContext)();
  const helpLink = docLinks.links.ml.dataFrameAnalytics;
  const jobIdToUse = jobId !== null && jobId !== void 0 ? jobId : analyticsId === null || analyticsId === void 0 ? void 0 : analyticsId.job_id;
  const [analysisTypeToUse, setAnalysisTypeToUse] = (0, _react.useState)(analysisType || (analyticsId === null || analyticsId === void 0 ? void 0 : analyticsId.analysis_type));
  const [, setGlobalState] = (0, _mlUrlState.useUrlState)('_g');
  const checkJobsExist = async () => {
    try {
      const {
        count
      } = await getDataFrameAnalytics(undefined, undefined, 0);
      setJobsExist(count > 0);
    } catch (e) {
      // Swallow the error and just show the empty table in the analytics id selector
      console.error('Error checking analytics jobs exist', e); // eslint-disable-line no-console
    }
  };

  // The inner components of the results page don't have a concept of reloading the full page.
  // Because we might want to refresh though if a user has to fix unsynced saved objects,
  // we achieve this here by unmounting the inner pages first by setting `analysisTypeToUse`
  // to `undefined`. The `useEffect()` below will then check if `analysisTypeToUse` doesn't
  // match the passed in analyis type and will update it once again, the re-mounted
  // page will then again fetch the most recent results.
  const refresh = () => {
    setAnalysisTypeToUse(undefined);
  };
  (0, _react.useEffect)(function checkRefresh() {
    if (analysisTypeToUse !== analysisType || analyticsId !== null && analyticsId !== void 0 && analyticsId.analysis_type) {
      setAnalysisTypeToUse(analysisType || (analyticsId === null || analyticsId === void 0 ? void 0 : analyticsId.analysis_type));
    }
  }, [analyticsId, analysisType, analysisTypeToUse]);
  (0, _react.useEffect)(function checkJobs() {
    checkJobsExist();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(function updateUrl() {
    if (analyticsId !== undefined) {
      setGlobalState({
        ml: {
          ...(analyticsId.analysis_type ? {
            analysisType: analyticsId.analysis_type
          } : {}),
          ...(analyticsId.job_id ? {
            jobId: analyticsId.job_id
          } : {})
        }
      });
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [analyticsId === null || analyticsId === void 0 ? void 0 : analyticsId.job_id, analyticsId === null || analyticsId === void 0 ? void 0 : analyticsId.model_id]);
  const getEmptyState = () => {
    if (jobsExist === false) {
      return /*#__PURE__*/_react.default.createElement(_empty_prompt.AnalyticsEmptyPrompt, null);
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.dataframe.analyticsMap.noJobSelectedLabel",
        defaultMessage: "No Analytics ID selected"
      })),
      "data-test-subj": "mlNoAnalyticsFound"
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_analytics_selector.AnalyticsIdSelectorControls, {
    setIsIdSelectorFlyoutVisible: setIsIdSelectorFlyoutVisible,
    selectedId: jobIdToUse
  }), isIdSelectorFlyoutVisible ? /*#__PURE__*/_react.default.createElement(_analytics_selector.AnalyticsIdSelector, {
    setAnalyticsId: setAnalyticsId,
    setIsIdSelectorFlyoutVisible: setIsIdSelectorFlyoutVisible
  }) : null, jobIdToUse !== undefined && /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analyticsExploration.titleWithId",
    defaultMessage: "Explore results for job ID {id}",
    values: {
      id: jobIdToUse
    }
  })), jobIdToUse === undefined && /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analyticsExploration.title",
    defaultMessage: "Explore results"
  })), /*#__PURE__*/_react.default.createElement(_saved_objects_warning.SavedObjectsWarning, {
    onCloseFlyout: refresh
  }), jobIdToUse && analysisTypeToUse ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlPageDataFrameAnalyticsExploration"
  }, analysisTypeToUse === _data_frame_analytics.ANALYSIS_CONFIG_TYPE.OUTLIER_DETECTION && /*#__PURE__*/_react.default.createElement(_outlier_exploration.OutlierExploration, {
    jobId: jobIdToUse
  }), analysisTypeToUse === _data_frame_analytics.ANALYSIS_CONFIG_TYPE.REGRESSION && /*#__PURE__*/_react.default.createElement(_regression_exploration.RegressionExploration, {
    jobId: jobIdToUse
  }), analysisTypeToUse === _data_frame_analytics.ANALYSIS_CONFIG_TYPE.CLASSIFICATION && /*#__PURE__*/_react.default.createElement(_classification_exploration.ClassificationExploration, {
    jobId: jobIdToUse
  })) : getEmptyState(), /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
    docLink: helpLink
  }));
};
exports.Page = Page;