"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOutlierScoreFieldName = exports.getFeatureCount = void 0;
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getOutlierScoreFieldName = jobConfig => `${jobConfig.dest.results_field}.${_constants.OUTLIER_SCORE}`;
exports.getOutlierScoreFieldName = getOutlierScoreFieldName;
const getFeatureCount = (resultsField, tableItems = []) => {
  return tableItems.reduce((featureCount, fullItem) => {
    if (Array.isArray(fullItem[`${resultsField}.${_constants.FEATURE_INFLUENCE}`])) {
      return Math.max(featureCount, fullItem[`${resultsField}.${_constants.FEATURE_INFLUENCE}`].length);
    }
    return featureCount;
  }, 0);
};
exports.getFeatureCount = getFeatureCount;