"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobConfigErrorCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../../contexts/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const jobConfigErrorTitle = _i18n.i18n.translate('xpack.ml.dataframe.analytics.jobConfig.errorTitle', {
  defaultMessage: 'Unable to fetch results. An error occurred loading the job configuration data.'
});
const jobCapsErrorTitle = _i18n.i18n.translate('xpack.ml.dataframe.analytics.jobCaps.errorTitle', {
  defaultMessage: "Unable to fetch results. An error occurred loading the index's field data."
});
const JobConfigErrorCallout = ({
  jobCapsServiceErrorMessage,
  jobConfigErrorMessage,
  title
}) => {
  const {
    services: {
      application: {
        getUrlForApp
      }
    }
  } = (0, _kibana.useMlKibana)();
  const containsIndexPatternLink = typeof jobCapsServiceErrorMessage === 'string' && jobCapsServiceErrorMessage.includes('locate that index-pattern') && jobCapsServiceErrorMessage.includes('click here to re-create');
  const message = /*#__PURE__*/_react.default.createElement("p", null, jobConfigErrorMessage ? jobConfigErrorMessage : jobCapsServiceErrorMessage);
  const newIndexPatternUrl = (0, _react.useMemo)(() => getUrlForApp('management', {
    path: 'kibana/indexPatterns'
  }),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const calloutBody = containsIndexPatternLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: newIndexPatternUrl,
    target: "_blank"
  }, message) : message;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: jobConfigErrorMessage ? jobConfigErrorTitle : jobCapsErrorTitle,
    color: "danger",
    iconType: "cross"
  }, calloutBody));
};
exports.JobConfigErrorCallout = JobConfigErrorCallout;