"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DecisionPathPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _decision_path_regression = require("./decision_path_regression");
var _decision_path_json_viewer = require("./decision_path_json_viewer");
var _feature_importance = require("../../../../../../../common/types/feature_importance");
var _common = require("../../../../common");
var _decision_path_classification = require("./decision_path_classification");
var _kibana = require("../../../../../contexts/kibana");
var _use_classification_path_data = require("./use_classification_path_data");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var DECISION_PATH_TABS;
(function (DECISION_PATH_TABS) {
  DECISION_PATH_TABS["CHART"] = "decision_path_chart";
  DECISION_PATH_TABS["JSON"] = "decision_path_json";
})(DECISION_PATH_TABS || (DECISION_PATH_TABS = {}));
const DecisionPathPopover = ({
  baseline,
  featureImportance,
  predictedValue,
  topClasses,
  analysisType,
  predictionFieldName,
  predictedProbability
}) => {
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(DECISION_PATH_TABS.CHART);
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const docLink = docLinks.links.ml.featureImportance;
  if (featureImportance.length < 2) {
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "mlDFADecisionPathJSONViewer"
    }, /*#__PURE__*/_react.default.createElement(_decision_path_json_viewer.DecisionPathJSONViewer, {
      featureImportance: featureImportance
    }));
  }
  const tabs = [{
    id: DECISION_PATH_TABS.CHART,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.explorationResults.decisionPathPlotTab",
      defaultMessage: "Decision plot"
    })
  }, {
    id: DECISION_PATH_TABS.JSON,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.explorationResults.decisionPathJSONTab",
      defaultMessage: "JSON"
    })
  }];
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlDFADecisionPathPopover"
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: 'flex',
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: 's'
  }, tabs.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    "data-test-subj": `mlDFADecisionPathPopoverTab-${tab.id}`,
    isSelected: tab.id === selectedTabId,
    onClick: () => setSelectedTabId(tab.id),
    key: tab.id
  }, tab.name)))), selectedTabId === DECISION_PATH_TABS.CHART && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 'xs',
    color: "subdued",
    style: {
      paddingTop: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.explorationResults.decisionPathPlotHelpText",
    defaultMessage: "SHAP decision plots use {linkedFeatureImportanceValues} to show how models arrive at the predicted value for '{predictionFieldName}'.",
    values: {
      predictionFieldName,
      linkedFeatureImportanceValues: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLink,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.dataframe.analytics.explorationResults.linkedFeatureImportanceValues",
        defaultMessage: "feature importance values"
      }))
    }
  })), analysisType === _common.ANALYSIS_CONFIG_TYPE.CLASSIFICATION && (0, _feature_importance.isClassificationFeatureImportanceBaseline)(baseline) && /*#__PURE__*/_react.default.createElement(_decision_path_classification.ClassificationDecisionPath, {
    featureImportance: featureImportance,
    topClasses: topClasses,
    predictedValue: (0, _use_classification_path_data.getStringBasedClassName)(predictedValue),
    predictedProbability: predictedProbability,
    predictionFieldName: predictionFieldName,
    baseline: baseline
  }), analysisType === _common.ANALYSIS_CONFIG_TYPE.REGRESSION && (0, _feature_importance.isRegressionFeatureImportanceBaseline)(baseline) && predictedValue !== undefined && /*#__PURE__*/_react.default.createElement(_decision_path_regression.RegressionDecisionPath, {
    featureImportance: featureImportance,
    baseline: baseline,
    predictedValue: typeof predictedValue === 'string' ? parseFloat(predictedValue) : predictedValue,
    predictionFieldName: predictionFieldName
  })), selectedTabId === DECISION_PATH_TABS.JSON && /*#__PURE__*/_react.default.createElement(_decision_path_json_viewer.DecisionPathJSONViewer, {
    featureImportance: featureImportance
  }));
};
exports.DecisionPathPopover = DecisionPathPopover;