"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClassificationDecisionPath = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _d = _interopRequireDefault(require("d3"));
var _use_classification_path_data = require("./use_classification_path_data");
var _decision_path_chart = require("./decision_path_chart");
var _missing_decision_path_callout = require("./missing_decision_path_callout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ClassificationDecisionPath = ({
  featureImportance,
  predictedValue,
  topClasses,
  predictionFieldName,
  predictedProbability,
  baseline
}) => {
  const [currentClass, setCurrentClass] = (0, _react.useState)((0, _use_classification_path_data.getStringBasedClassName)(topClasses[0].class_name));
  const selectedClass = topClasses.find(t => (0, _use_classification_path_data.getStringBasedClassName)(t.class_name) === (0, _use_classification_path_data.getStringBasedClassName)(currentClass));
  const predictedProbabilityForCurrentClass = selectedClass ? selectedClass.class_probability : undefined;
  const {
    decisionPathData
  } = (0, _use_classification_path_data.useDecisionPathData)({
    baseline,
    featureImportance,
    predictedValue: currentClass,
    predictedProbability: predictedProbabilityForCurrentClass
  });
  const options = (0, _react.useMemo)(() => {
    const predictionValueStr = (0, _use_classification_path_data.getStringBasedClassName)(predictedValue);
    return Array.isArray(topClasses) ? topClasses.map(c => {
      const className = (0, _use_classification_path_data.getStringBasedClassName)(c.class_name);
      return {
        value: className,
        inputDisplay: className === predictionValueStr ? /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
          color: "success",
          style: {
            lineHeight: 'inherit'
          }
        }, className) : className
      };
    }) : undefined;
  }, [topClasses, predictedValue]);
  const domain = (0, _react.useMemo)(() => {
    let maxDomain;
    let minDomain;
    // if decisionPathData has calculated cumulative path
    if (decisionPathData && (0, _use_classification_path_data.isDecisionPathData)(decisionPathData)) {
      const [min, max] = _d.default.extent(decisionPathData, d => d[2]);
      const buffer = Math.abs(max - min) * 0.1;
      maxDomain = max + buffer;
      minDomain = min - buffer;
    }
    return {
      maxDomain,
      minDomain
    };
  }, [decisionPathData]);
  if (!decisionPathData) return /*#__PURE__*/_react.default.createElement(_missing_decision_path_callout.MissingDecisionPathCallout, null);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'xs'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: 'xxxs'
  }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.ml.dataframe.analytics.explorationResults.classificationDecisionPathClassNameTitle', {
    defaultMessage: 'Class name'
  }))), options !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    "data-test-subj": "mlDFADecisionPathClassNameSelect",
    compressed: true,
    options: options,
    valueOfSelected: currentClass,
    onChange: setCurrentClass
  }), /*#__PURE__*/_react.default.createElement(_decision_path_chart.DecisionPathChart, {
    decisionPathData: decisionPathData,
    predictionFieldName: predictionFieldName,
    minDomain: domain.minDomain,
    maxDomain: domain.maxDomain
  }));
};
exports.ClassificationDecisionPath = ClassificationDecisionPath;