"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DecisionPathChart = void 0;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
var _format_value = require("../../../../../formatters/format_value");
var _feature_importance = require("../../../../../../../common/types/feature_importance");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  euiColorFullShade,
  euiColorMediumShade
} = _uiTheme.euiLightVars;
const axisColor = euiColorMediumShade;
const baselineStyle = {
  line: {
    strokeWidth: 1,
    stroke: euiColorFullShade,
    opacity: 0.75
  },
  details: {
    fontFamily: 'Arial',
    fontSize: 10,
    fill: euiColorMediumShade,
    padding: 0
  }
};
const axes = {
  axisLine: {
    stroke: axisColor
  },
  tickLabel: {
    fontSize: 10,
    fill: axisColor
  },
  tickLine: {
    stroke: axisColor
  },
  gridLine: {
    horizontal: {
      dash: [1, 2]
    },
    vertical: {
      strokeWidth: 0
    }
  }
};
const theme = {
  axes
};
const DECISION_PATH_MARGIN = 125;
const DECISION_PATH_ROW_HEIGHT = 10;
const AnnotationBaselineMarker = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: "dot",
  size: "m"
});
const DecisionPathChart = ({
  decisionPathData,
  predictionFieldName,
  minDomain,
  maxDomain,
  baseline
}) => {
  const regressionBaselineData = (0, _react.useMemo)(() => baseline && (0, _feature_importance.isRegressionFeatureImportanceBaseline)(baseline) ? [{
    dataValue: baseline.baseline,
    header: (0, _format_value.formatSingleValue)(baseline.baseline, '').toString(),
    details: _i18n.i18n.translate('xpack.ml.dataframe.analytics.explorationResults.decisionPathBaselineText', {
      defaultMessage: 'baseline (average of predictions for all data points in the training data set)'
    })
  }] : undefined, [baseline]);
  const xAxisLabel = regressionBaselineData ? _i18n.i18n.translate('xpack.ml.dataframe.analytics.explorationResults.decisionPathLinePredictionTitle', {
    defaultMessage: 'Prediction'
  }) : _i18n.i18n.translate('xpack.ml.dataframe.analytics.explorationResults.decisionPathLinePredictionProbabilityTitle', {
    defaultMessage: 'Prediction probability'
  });
  // if regression, guarantee up to num_precision significant digits without having it in scientific notation
  // if classification, hide the numeric values since we only want to show the path
  const tickFormatter = (0, _react.useCallback)(d => (0, _format_value.formatSingleValue)(d, '').toString(), []);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlDFADecisionPathChart"
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: DECISION_PATH_MARGIN + decisionPathData.length * DECISION_PATH_ROW_HEIGHT
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings
  // TODO use the EUI charts theme see src/plugins/charts/public/services/theme/README.md
  , {
    theme: theme,
    rotation: 90
  }), regressionBaselineData && /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "xpack.ml.dataframe.analytics.explorationResults.decisionPathBaseline",
    domainType: _charts.AnnotationDomainType.YDomain,
    dataValues: regressionBaselineData,
    style: baselineStyle,
    marker: AnnotationBaselineMarker
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: 'xpack.ml.dataframe.analytics.explorationResults.decisionPathXAxis',
    tickFormat: tickFormatter,
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.explorationResults.decisionPathXAxisTitle', {
      defaultMessage: "{xAxisLabel} for '{predictionFieldName}'",
      values: {
        predictionFieldName,
        xAxisLabel
      }
    }),
    showGridLines: false,
    position: _charts.Position.Top,
    showOverlappingTicks: true,
    domain: minDomain && maxDomain ? {
      min: minDomain,
      max: maxDomain
    } : undefined
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    showGridLines: true,
    id: "left",
    position: _charts.Position.Left
  }), /*#__PURE__*/_react.default.createElement(_charts.LineSeries, {
    id: 'xpack.ml.dataframe.analytics.explorationResults.decisionPathLine',
    name: xAxisLabel,
    xScaleType: _charts.ScaleType.Ordinal,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: 0,
    yAccessors: [2],
    data: decisionPathData
  })));
};
exports.DecisionPathChart = DecisionPathChart;