"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useExplorationDataGrid = void 0;
var _react = require("react");
var _useUpdateEffect = _interopRequireDefault(require("react-use/lib/useUpdateEffect"));
var _data_grid = require("../../../../../components/data_grid");
var _use_exploration_url_state = require("../../hooks/use_exploration_url_state");
var _common = require("../../../../../components/data_grid/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useExplorationDataGrid = (columns, defaultVisibleColumnsCount = _common.INIT_MAX_COLUMNS, defaultVisibleColumnsFilter) => {
  const [pageUrlState, setPageUrlState] = (0, _use_exploration_url_state.useExplorationUrlState)();
  const dataGrid = (0, _data_grid.useDataGrid)(columns, 25, defaultVisibleColumnsCount, defaultVisibleColumnsFilter);

  // Override dataGrid config to use URL state.
  dataGrid.pagination = (0, _react.useMemo)(() => ({
    pageSize: pageUrlState.pageSize,
    pageIndex: pageUrlState.pageIndex
  }), [pageUrlState.pageSize, pageUrlState.pageIndex]);
  dataGrid.setPagination = (0, _react.useCallback)(u => {
    setPageUrlState({
      ...u
    });
  }, [setPageUrlState]);
  dataGrid.onChangePage = (0, _react.useCallback)(pageIndex => {
    setPageUrlState({
      pageIndex
    });
  }, [setPageUrlState]);
  dataGrid.onChangeItemsPerPage = (0, _react.useCallback)(pageSize => {
    setPageUrlState({
      pageSize
    });
  }, [setPageUrlState]);
  dataGrid.resetPagination = (0, _react.useCallback)(() => {
    const a = (0, _use_exploration_url_state.getDefaultExplorationPageUrlState)();
    setPageUrlState({
      pageSize: a.pageSize,
      pageIndex: a.pageIndex
    });
  }, [setPageUrlState]);
  (0, _useUpdateEffect.default)(function resetPaginationOnQueryChange() {
    dataGrid.resetPagination();
  }, [pageUrlState.queryText]);
  return dataGrid;
};
exports.useExplorationDataGrid = useExplorationDataGrid;