"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplorationPageWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _analytics_utils = require("../../../../../../../common/util/analytics_utils");
var _scatterplot_matrix = require("../../../../../components/scatterplot_matrix");
var _common = require("../../../../common");
var _analytics = require("../../../../common/analytics");
var _expandable_section = require("../expandable_section");
var _exploration_results_table = require("../exploration_results_table");
var _exploration_query_bar = require("../exploration_query_bar");
var _job_config_error_callout = require("../job_config_error_callout");
var _loading_panel = require("../loading_panel");
var _use_exploration_url_state = require("../../hooks/use_exploration_url_state");
var _index_pattern_prompt = require("../index_pattern_prompt");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getFilters(resultsField) {
  return {
    options: [{
      id: 'training',
      label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.explorationResults.trainingSubsetLabel', {
        defaultMessage: 'Training'
      })
    }, {
      id: 'testing',
      label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.explorationResults.testingSubsetLabel', {
        defaultMessage: 'Testing'
      })
    }],
    columnId: `${resultsField}.is_training`,
    key: {
      training: true,
      testing: false
    }
  };
}
const ExplorationPageWrapper = ({
  jobId,
  title,
  EvaluatePanel,
  FeatureImportanceSummaryPanel
}) => {
  var _jobConfig$dest$resul, _jobConfig$analyzed_f, _jobConfig$analyzed_f2;
  const {
    indexPattern,
    indexPatternErrorMessage,
    isInitialized,
    isLoadingJobConfig,
    jobCapsServiceErrorMessage,
    jobConfig,
    jobConfigErrorMessage,
    jobStatus,
    needsDestIndexPattern,
    totalFeatureImportance
  } = (0, _common.useResultsViewConfig)(jobId);
  const [pageUrlState, setPageUrlState] = (0, _use_exploration_url_state.useExplorationUrlState)();
  const [searchQuery, setSearchQuery] = (0, _react.useState)(_common.defaultSearchQuery);
  const searchQueryUpdateHandler = (0, _react.useCallback)(update => {
    if (update.query) {
      setSearchQuery(update.query);
    }
    if (update.queryString !== pageUrlState.queryText) {
      setPageUrlState({
        queryText: update.queryString,
        queryLanguage: update.language
      });
    }
  }, [pageUrlState, setPageUrlState]);
  const query = {
    query: pageUrlState.queryText,
    language: pageUrlState.queryLanguage
  };
  const resultsField = (_jobConfig$dest$resul = jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.dest.results_field) !== null && _jobConfig$dest$resul !== void 0 ? _jobConfig$dest$resul : '';
  const destIndex = (0, _common.getDestinationIndex)(jobConfig);
  const scatterplotFieldOptions = (0, _scatterplot_matrix.useScatterplotFieldOptions)(indexPattern, jobConfig === null || jobConfig === void 0 ? void 0 : (_jobConfig$analyzed_f = jobConfig.analyzed_fields) === null || _jobConfig$analyzed_f === void 0 ? void 0 : _jobConfig$analyzed_f.includes, jobConfig === null || jobConfig === void 0 ? void 0 : (_jobConfig$analyzed_f2 = jobConfig.analyzed_fields) === null || _jobConfig$analyzed_f2 === void 0 ? void 0 : _jobConfig$analyzed_f2.excludes, resultsField);
  if (indexPatternErrorMessage !== undefined) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.exploration.indexError', {
        defaultMessage: 'An error occurred loading the index data.'
      }),
      color: "danger",
      iconType: "cross"
    }, /*#__PURE__*/_react.default.createElement("p", null, indexPatternErrorMessage, needsDestIndexPattern ? /*#__PURE__*/_react.default.createElement(_index_pattern_prompt.IndexPatternPrompt, {
      destIndex: destIndex,
      color: "text"
    }) : null)));
  }
  if (jobConfigErrorMessage !== undefined || jobCapsServiceErrorMessage !== undefined) {
    return /*#__PURE__*/_react.default.createElement(_job_config_error_callout.JobConfigErrorCallout, {
      jobCapsServiceErrorMessage: jobCapsServiceErrorMessage,
      jobConfigErrorMessage: jobConfigErrorMessage,
      title: title
    });
  }
  const jobType = jobConfig && jobConfig.analysis ? (0, _analytics_utils.getAnalysisType)(jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.analysis) : undefined;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, typeof (jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.description) !== 'undefined' && (jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.description) !== '' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.description), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), indexPattern !== undefined && jobConfig && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_exploration_query_bar.ExplorationQueryBar, {
    indexPattern: indexPattern,
    setSearchQuery: searchQueryUpdateHandler,
    query: query,
    filters: getFilters(jobConfig.dest.results_field)
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), isLoadingJobConfig === true && jobConfig === undefined && /*#__PURE__*/_react.default.createElement(_loading_panel.LoadingPanel, null), isLoadingJobConfig === false && jobConfig !== undefined && isInitialized === true && /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSectionAnalytics, {
    jobId: jobConfig.id
  }), isLoadingJobConfig === true && jobConfig === undefined && /*#__PURE__*/_react.default.createElement(_loading_panel.LoadingPanel, null), isLoadingJobConfig === false && jobConfig !== undefined && isInitialized === true && /*#__PURE__*/_react.default.createElement(EvaluatePanel, {
    jobConfig: jobConfig,
    jobStatus: jobStatus,
    searchQuery: searchQuery
  }), isLoadingJobConfig === true && jobConfig !== undefined && totalFeatureImportance === undefined && /*#__PURE__*/_react.default.createElement(_loading_panel.LoadingPanel, null), isLoadingJobConfig === false && jobConfig !== undefined && totalFeatureImportance !== undefined && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FeatureImportanceSummaryPanel, {
    totalFeatureImportance: totalFeatureImportance,
    jobConfig: jobConfig
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), isLoadingJobConfig === true && jobConfig === undefined && /*#__PURE__*/_react.default.createElement(_loading_panel.LoadingPanel, null), isLoadingJobConfig === false && jobConfig !== undefined && isInitialized === true && typeof (jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.id) === 'string' && scatterplotFieldOptions.length > 1 && typeof (jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.analysis) !== 'undefined' && /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSectionSplom, {
    fields: scatterplotFieldOptions,
    index: jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.dest.index,
    indexPattern: indexPattern,
    color: jobType === _analytics.ANALYSIS_CONFIG_TYPE.REGRESSION || jobType === _analytics.ANALYSIS_CONFIG_TYPE.CLASSIFICATION ? (0, _analytics_utils.getDependentVar)(jobConfig.analysis) : undefined,
    legendType: (0, _common.getScatterplotMatrixLegendType)(jobType),
    searchQuery: searchQuery
  }), isLoadingJobConfig === true && jobConfig === undefined && /*#__PURE__*/_react.default.createElement(_loading_panel.LoadingPanel, null), isLoadingJobConfig === false && jobConfig !== undefined && indexPattern !== undefined && isInitialized === true && /*#__PURE__*/_react.default.createElement(_exploration_results_table.ExplorationResultsTable, {
    indexPattern: indexPattern,
    jobConfig: jobConfig,
    jobStatus: jobStatus,
    needsDestIndexPattern: needsDestIndexPattern,
    searchQuery: searchQuery
  }));
};
exports.ExplorationPageWrapper = ExplorationPageWrapper;