"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HEADER_ITEMS_LOADING = exports.ExpandableSection = void 0;
require("./expandable_section.scss");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_exploration_url_state = require("../../hooks/use_exploration_url_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isHeaderItems = arg => {
  return Array.isArray(arg);
};
const HEADER_ITEMS_LOADING = 'header_items_loading';
exports.HEADER_ITEMS_LOADING = HEADER_ITEMS_LOADING;
const ExpandableSection = ({
  headerItems,
  content,
  isExpanded: isExpandedDefault,
  contentPadding = false,
  dataTestId,
  title,
  docsLink,
  urlStateKey
}) => {
  const overrides = (0, _react.useMemo)(() => isExpandedDefault !== undefined ? {
    [urlStateKey]: isExpandedDefault
  } : undefined, [urlStateKey, isExpandedDefault]);
  const [pageUrlState, setPageUrlState] = (0, _use_exploration_url_state.useExplorationUrlState)(overrides);
  const isExpanded = isExpandedDefault !== undefined && pageUrlState[urlStateKey] === (0, _use_exploration_url_state.getDefaultExplorationPageUrlState)(overrides)[urlStateKey] ? isExpandedDefault : pageUrlState[urlStateKey];
  const toggleExpanded = (0, _react.useCallback)(() => {
    setPageUrlState({
      [urlStateKey]: !isExpanded
    });
  }, [isExpanded, setPageUrlState, urlStateKey]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    "data-test-subj": `mlDFExpandableSection-${dataTestId}`,
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "mlExpandableSection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "none",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: toggleExpanded,
    iconType: isExpanded ? 'arrowDown' : 'arrowRight',
    iconSide: "left",
    flush: "left",
    "data-test-subj": `mlDFExpandableSection-${dataTestId}-toggle-button`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    color: "default",
    style: {
      fontWeight: 'bold'
    }
  }, /*#__PURE__*/_react.default.createElement("p", null, title)))), headerItems === HEADER_ITEMS_LOADING && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingContent, {
    lines: 1
  }), isHeaderItems(headerItems) ? headerItems.map(({
    label,
    value,
    id
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: id,
    "data-test-subj": `mlDFExpandableSectionItem-${dataTestId}-${id}`
  }, label !== undefined && value !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement("p", null, label))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, value))) : null, label === undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    textAlign: "center"
  }, value))) : null)) : null)), docsLink !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, docsLink))), isExpanded && /*#__PURE__*/_react.default.createElement("div", {
    className: contentPadding ? 'mlExpandableSection-contentPadding' : '',
    "data-test-subj": `mlDFExpandableSection-${dataTestId}-content`
  }, content));
};
exports.ExpandableSection = ExpandableSection;