"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EvaluatePanel = void 0;
require("./_classification_exploration.scss");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _kibana = require("../../../../../contexts/kibana");
var _vega_chart = require("../../../../../components/vega_chart");
var _vega_chart_loading = require("../../../../../components/vega_chart/vega_chart_loading");
var _error_callout = require("../error_callout");
var _common = require("../../../../common");
var _expandable_section = require("../expandable_section");
var _evaluate_stat = require("./evaluate_stat");
var _evaluation_quality_metrics_table = require("./evaluation_quality_metrics_table");
var _get_roc_curve_chart_vega_lite_spec = require("./get_roc_curve_chart_vega_lite_spec");
var _column_data = require("./column_data");
var _is_training_filter = require("./is_training_filter");
var _use_roc_curve = require("./use_roc_curve");
var _use_confusion_matrix = require("./use_confusion_matrix");
var _confusion_matrix_help_popover = require("./confusion_matrix_help_popover");
var _roc_curve_help_popover = require("./roc_curve_help_popover");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// Separate imports for lazy loadable VegaChart and related code
var SUBSET_TITLE;
(function (SUBSET_TITLE) {
  SUBSET_TITLE["TRAINING"] = "training";
  SUBSET_TITLE["TESTING"] = "testing";
  SUBSET_TITLE["ENTIRE"] = "entire";
})(SUBSET_TITLE || (SUBSET_TITLE = {}));
const entireDatasetHelpText = _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.confusionMatrixEntireHelpText', {
  defaultMessage: 'Normalized confusion matrix for entire dataset'
});
const testingDatasetHelpText = _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.confusionMatrixTestingHelpText', {
  defaultMessage: 'Normalized confusion matrix for testing dataset'
});
const trainingDatasetHelpText = _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.confusionMatrixTrainingHelpText', {
  defaultMessage: 'Normalized confusion matrix for training dataset'
});
const evaluationQualityMetricsHelpText = _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.evaluationQualityMetricsHelpText', {
  defaultMessage: 'Evaluation quality metrics'
});
function getHelpText(dataSubsetTitle) {
  let helpText = entireDatasetHelpText;
  if (dataSubsetTitle === SUBSET_TITLE.TESTING) {
    helpText = testingDatasetHelpText;
  } else if (dataSubsetTitle === SUBSET_TITLE.TRAINING) {
    helpText = trainingDatasetHelpText;
  }
  return helpText;
}
const EvaluatePanel = ({
  jobConfig,
  jobStatus,
  searchQuery
}) => {
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const {
    euiTheme
  } = (0, _kibana.useCurrentThemeVars)();
  const [columns, setColumns] = (0, _react.useState)([]);
  const [columnsData, setColumnsData] = (0, _react.useState)([]);
  const [showFullColumns, setShowFullColumns] = (0, _react.useState)(false);
  const [dataSubsetTitle, setDataSubsetTitle] = (0, _react.useState)(SUBSET_TITLE.ENTIRE);
  // Column visibility
  const [visibleColumns, setVisibleColumns] = (0, _react.useState)(() => columns.map(({
    id
  }) => id));
  const resultsField = jobConfig.dest.results_field;
  const isTraining = (0, _is_training_filter.isTrainingFilter)(searchQuery, resultsField);
  const {
    avgRecall,
    confusionMatrixData,
    docsCount,
    error: errorConfusionMatrix,
    isLoading: isLoadingConfusionMatrix,
    overallAccuracy,
    evaluationMetricsItems
  } = (0, _use_confusion_matrix.useConfusionMatrix)(jobConfig, searchQuery);
  (0, _react.useEffect)(() => {
    if (isTraining === undefined) {
      setDataSubsetTitle(SUBSET_TITLE.ENTIRE);
    } else {
      setDataSubsetTitle(isTraining && isTraining === true ? SUBSET_TITLE.TRAINING : SUBSET_TITLE.TESTING);
    }
  }, [isTraining]);
  (0, _react.useEffect)(() => {
    if (confusionMatrixData.length > 0) {
      const {
        columns: derivedColumns,
        columnData
      } = (0, _column_data.getColumnData)(confusionMatrixData);
      // Initialize all columns as visible
      setVisibleColumns(() => derivedColumns.map(({
        id
      }) => id));
      setColumns(derivedColumns);
      setColumnsData(columnData);
    }
  }, [confusionMatrixData]);
  const {
    rocCurveData,
    classificationClasses,
    error: errorRocCurve,
    isLoading: isLoadingRocCurve
  } = (0, _use_roc_curve.useRocCurve)(jobConfig, searchQuery, columns.map(d => d.id));
  const renderCellValue = ({
    rowIndex,
    columnId,
    setCellProps,
    schema,
    isDetails
  }) => {
    const cellValue = columnId === _column_data.ACTUAL_CLASS_ID ? columnsData[rowIndex][columnId] : columnsData[rowIndex].predicted_classes_count[columnId];
    const actualCount = columnsData[rowIndex] && columnsData[rowIndex].actual_class_doc_count;
    let accuracy = '0%';
    if (columnId !== _column_data.ACTUAL_CLASS_ID && actualCount && typeof cellValue === 'number') {
      let accuracyNumber = cellValue / actualCount;
      // round to 2 decimal places without converting to string;
      accuracyNumber = Math.round(accuracyNumber * 100) / 100;
      accuracy = `${Math.round(accuracyNumber * 100)}%`;
    }

    // eslint-disable-next-line react-hooks/rules-of-hooks
    (0, _react.useEffect)(() => {
      if (columnId !== _column_data.ACTUAL_CLASS_ID) {
        setCellProps({
          style: {
            backgroundColor: `rgba(0, 179, 164, ${accuracy})`
          }
        });
      }
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [rowIndex, columnId, setCellProps]);
    let cellContent = columnId === _column_data.ACTUAL_CLASS_ID ? cellValue : accuracy;

    // Custom popover content for numeric schemas
    if (isDetails && schema === 'numeric') {
      const gridItem = columnsData[rowIndex];
      if (gridItem !== undefined && columnId !== _column_data.ACTUAL_CLASS_ID) {
        const count = gridItem.predicted_classes_count[columnId];
        cellContent = `${count} / ${gridItem.actual_class_doc_count} * 100 = ${cellContent}`;
      }
    }
    return /*#__PURE__*/_react.default.createElement("span", null, cellContent);
  };
  const docLink = docLinks.links.ml.classificationEvaluation;
  const showTrailingColumns = columnsData.length > _column_data.MAX_COLUMNS;
  const extraColumns = columnsData.length - _column_data.MAX_COLUMNS;
  const shownColumns = showTrailingColumns === true && showFullColumns === false ? columns.slice(0, _column_data.MAX_COLUMNS + 1) : columns;
  const rowCount = showTrailingColumns === true && showFullColumns === false ? _column_data.MAX_COLUMNS : columnsData.length;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    urlStateKey: 'evaluation',
    dataTestId: "ClassificationEvaluation",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.classificationExploration.evaluateSectionTitle",
      defaultMessage: "Model evaluation"
    }),
    docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      target: "_blank",
      iconType: "help",
      iconSide: "left",
      size: "xs",
      color: "primary",
      href: docLink
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "primary"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.classificationExploration.classificationDocsLink",
      defaultMessage: "Classification evaluation docs "
    }))),
    headerItems: !isLoadingConfusionMatrix ? [...(jobStatus !== undefined ? [{
      id: 'jobStatus',
      label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.evaluateJobStatusLabel', {
        defaultMessage: 'Job status'
      }),
      value: jobStatus
    }] : []), ...(docsCount !== null ? [{
      id: 'docsEvaluated',
      label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.generalizationDocsCount', {
        defaultMessage: '{docsCount, plural, one {doc} other {docs}} evaluated',
        values: {
          docsCount
        }
      }),
      value: docsCount
    }] : [])] : _expandable_section.HEADER_ITEMS_LOADING,
    contentPadding: true,
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isLoadingConfusionMatrix ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, errorConfusionMatrix !== null && /*#__PURE__*/_react.default.createElement(_error_callout.ErrorCallout, {
      error: errorConfusionMatrix
    }), errorConfusionMatrix === null && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("span", null, getHelpText(dataSubsetTitle))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_confusion_matrix_help_popover.MulticlassConfusionMatrixHelpPopover, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement("div", {
      className: "mlDataFrameAnalyticsClassification__evaluateSectionContent"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "mlDataFrameAnalyticsClassification__actualLabel"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.classificationExploration.confusionMatrixActualLabel",
      defaultMessage: "Actual class"
    }))), /*#__PURE__*/_react.default.createElement("div", {
      className: "mlDataFrameAnalyticsClassification__dataGridMinWidth"
    }, columns.length > 0 && columnsData.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.classificationExploration.confusionMatrixPredictedLabel",
      defaultMessage: "Predicted class"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiDataGrid, {
      "data-test-subj": "mlDFAnalyticsClassificationExplorationConfusionMatrix",
      "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.confusionMatrixLabel', {
        defaultMessage: 'Classification confusion matrix'
      }),
      columns: shownColumns,
      columnVisibility: {
        visibleColumns,
        setVisibleColumns
      },
      rowCount: rowCount,
      renderCellValue: renderCellValue,
      inMemory: {
        level: 'sorting'
      },
      toolbarVisibility: {
        showColumnSelector: true,
        showDisplaySelector: false,
        showFullScreenSelector: false,
        showSortSelector: false
      },
      gridStyle: {
        border: 'all',
        fontSize: 's',
        cellPadding: 's',
        stripes: false,
        rowHover: 'none',
        header: 'shade'
      },
      trailingControlColumns: showTrailingColumns === true && showFullColumns === false ? (0, _column_data.getTrailingControlColumns)(extraColumns, setShowFullColumns) : undefined
    })))))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xl"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("span", null, evaluationQualityMetricsHelpText)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      justifyContent: "center",
      className: "mlDataFrameAnalyticsClassification__evaluationMetrics"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "l"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_evaluate_stat.EvaluateStat, {
      dataTestSubj: 'mlDFAEvaluateSectionOverallAccuracyStat',
      title: overallAccuracy,
      isLoading: isLoadingConfusionMatrix,
      description: _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.evaluateSectionOverallAccuracyStat', {
        defaultMessage: 'Overall accuracy'
      }),
      tooltipContent: _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.evaluateSectionOverallAccuracyTooltip', {
        defaultMessage: 'The ratio of the number of correct class predictions to the total number of predictions.'
      })
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_evaluate_stat.EvaluateStat, {
      dataTestSubj: 'mlDFAEvaluateSectionAvgRecallStat',
      title: avgRecall,
      isLoading: isLoadingConfusionMatrix,
      description: _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.evaluateSectionMeanRecallStat', {
        defaultMessage: 'Mean recall'
      }),
      tooltipContent: _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.evaluateSectionAvgRecallTooltip', {
        defaultMessage: 'Mean recall shows how many of the data points that are actual class members were identified correctly as class members.'
      })
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_evaluation_quality_metrics_table.EvaluationQualityMetricsTable, {
      evaluationMetricsItems: evaluationMetricsItems
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.classificationExploration.evaluateSectionRocTitle",
      defaultMessage: "Receiver operating characteristic (ROC) curve"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_roc_curve_help_popover.RocCurveHelpPopover, null))), Array.isArray(errorRocCurve) && /*#__PURE__*/_react.default.createElement(_error_callout.ErrorCallout, {
      error: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, errorRocCurve.map(e => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, e, /*#__PURE__*/_react.default.createElement("br", null))))
    }), !isLoadingRocCurve && errorRocCurve === null && rocCurveData.length > 0 && /*#__PURE__*/_react.default.createElement("div", {
      className: "mlDataFrameAnalyticsClassification__evaluateSectionContent",
      "data-test-subj": "mlDFAnalyticsClassificationExplorationRocCurveChart"
    }, /*#__PURE__*/_react.default.createElement(_vega_chart.VegaChart, {
      vegaSpec: (0, _get_roc_curve_chart_vega_lite_spec.getRocCurveChartVegaLiteSpec)(classificationClasses, rocCurveData, (0, _common.getDependentVar)(jobConfig.analysis), euiTheme)
    })), isLoadingRocCurve && /*#__PURE__*/_react.default.createElement(_vega_chart_loading.VegaChartLoading, null))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.EvaluatePanel = EvaluatePanel;