"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValidationStep = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _callout = require("../../../../../components/callout");
var _page = require("../../page");
var _continue_button = require("../continue_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ValidationStep = ({
  checksInProgress,
  validationMessages,
  setCurrentStep
}) => {
  const callouts = validationMessages.map((m, i) => /*#__PURE__*/_react.default.createElement(_callout.Callout, (0, _extends2.default)({
    key: `${m.id}_${i}`
  }, m)));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, checksInProgress && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl"
  }), !checksInProgress && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, callouts, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_continue_button.ContinueButton, {
    isDisabled: false,
    onClick: () => {
      setCurrentStep(_page.ANALYTICS_STEPS.CREATE);
    }
  })));
};
exports.ValidationStep = ValidationStep;