"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuntimeMappingsEditor = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _runtime_field_utils = require("../../../../../../../common/util/runtime_field_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuntimeMappingsEditor = /*#__PURE__*/(0, _react.memo)(({
  convertToJson,
  xJsonMode,
  setAdvancedRuntimeMappingsConfig,
  setIsRuntimeMappingsEditorApplyButtonEnabled,
  advancedEditorRuntimeMappingsLastApplied,
  advancedRuntimeMappingsConfig
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlDataFrameAnalyticsAdvancedRuntimeMappingsEditor"
  }, /*#__PURE__*/_react.default.createElement(_public.CodeEditor, {
    height: 250,
    languageId: 'json',
    onChange: d => {
      setAdvancedRuntimeMappingsConfig(d);

      // Disable the "Apply"-Button if the config hasn't changed.
      if (advancedEditorRuntimeMappingsLastApplied === d) {
        setIsRuntimeMappingsEditorApplyButtonEnabled(false);
        return;
      }

      // Enable Apply button so user can remove previously created runtime field
      if (d === '') {
        setIsRuntimeMappingsEditorApplyButtonEnabled(true);
        return;
      }

      // Try to parse the string passed on from the editor.
      // If parsing fails, the "Apply"-Button will be disabled
      try {
        const parsedJson = JSON.parse(convertToJson(d));
        setIsRuntimeMappingsEditorApplyButtonEnabled((0, _runtime_field_utils.isRuntimeMappings)(parsedJson));
      } catch (e) {
        setIsRuntimeMappingsEditorApplyButtonEnabled(false);
      }
    },
    options: {
      ariaLabel: _i18n.i18n.translate('xpack.ml.dataframe.analytics.createWizard.runtimeMappings.advancedEditorAriaLabel', {
        defaultMessage: 'Advanced runtime editor'
      }),
      automaticLayout: true,
      fontSize: 12,
      scrollBeyondLastLine: false,
      quickSuggestions: true,
      minimap: {
        enabled: false
      },
      wordWrap: 'on',
      wrappingIndent: 'indent'
    },
    value: advancedRuntimeMappingsConfig
  }));
}, (prevProps, nextProps) => (0, _lodash.isEqual)(pickProps(prevProps), pickProps(nextProps)));
exports.RuntimeMappingsEditor = RuntimeMappingsEditor;
function pickProps(props) {
  return [props.advancedEditorRuntimeMappingsLastApplied, props.advancedRuntimeMappingsConfig];
}