"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailsStepForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _kibana = require("../../../../../contexts/kibana");
var _validation = require("../../../../../../../common/constants/validation");
var _continue_button = require("../continue_button");
var _page = require("../../page");
var _ml_api_service = require("../../../../../services/ml_api_service");
var _ml = require("../../../../../contexts/ml");
var _details_step_time_field = require("./details_step_time_field");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_RESULTS_FIELD = 'ml';
const indexNameExistsMessage = _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.destinationIndexHelpText', {
  defaultMessage: 'An index with this name already exists. Be aware that running this analytics job will modify this destination index.'
});
const DetailsStepForm = ({
  actions,
  state,
  setCurrentStep
}) => {
  const {
    services: {
      docLinks,
      notifications
    }
  } = (0, _kibana.useMlKibana)();
  const mlContext = (0, _ml.useMlContext)();
  const {
    currentDataView
  } = mlContext;
  const createIndexLink = docLinks.links.apis.createIndex;
  const {
    setFormState
  } = actions;
  const {
    form,
    cloneJob,
    hasSwitchedToEditor,
    isJobCreated
  } = state;
  const {
    description,
    destinationIndex,
    destinationIndexNameEmpty,
    destinationIndexNameExists,
    destinationIndexNameValid,
    jobId,
    jobIdEmpty,
    jobIdExists,
    jobIdInvalidMaxLength,
    jobIdValid,
    resultsField,
    timeFieldName
  } = form;
  const [destIndexSameAsId, setDestIndexSameAsId] = (0, _react.useState)(cloneJob === undefined && hasSwitchedToEditor === false);
  const [useResultsFieldDefault, setUseResultsFieldDefault] = (0, _react.useState)(cloneJob === undefined && hasSwitchedToEditor === false && resultsField === undefined || cloneJob !== undefined && resultsField === DEFAULT_RESULTS_FIELD);
  const [dataViewAvailableTimeFields, setDataViewAvailableTimeFields] = (0, _react.useState)([]);
  const onTimeFieldChanged = (0, _react.useCallback)(e => {
    const value = e.target.value;
    // If the value is an empty string, it's not a valid selection
    if (value === '') {
      return;
    }
    // Find the time field based on the selected value
    // this is to account for undefined when user chooses not to use a date field
    const timeField = dataViewAvailableTimeFields.find(col => col === value);
    setFormState({
      timeFieldName: timeField
    });
  }, [dataViewAvailableTimeFields, setFormState]);
  (0, _react.useEffect)(() => {
    // Default timeFieldName to the source data view's time field if it exists
    if (currentDataView !== undefined) {
      setFormState({
        timeFieldName: currentDataView.timeFieldName
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    // Get possible timefields for the results data view
    if (currentDataView !== undefined) {
      const timefields = currentDataView.fields.filter(f => f.type === 'date').map(f => f.name);
      setDataViewAvailableTimeFields(timefields);
    }
  }, [currentDataView, setFormState]);
  const forceInput = (0, _react.useRef)(null);
  const isStepInvalid = jobIdEmpty === true || jobIdExists === true || jobIdValid === false || destinationIndexNameEmpty === true || destinationIndexNameValid === false;
  const debouncedIndexCheck = (0, _lodash.debounce)(async () => {
    try {
      const resp = await _ml_api_service.ml.checkIndicesExists({
        indices: [destinationIndex]
      });
      setFormState({
        destinationIndexNameExists: resp[destinationIndex].exists
      });
    } catch (e) {
      notifications.toasts.addDanger(_i18n.i18n.translate('xpack.ml.dataframe.analytics.create.errorCheckingIndexExists', {
        defaultMessage: 'The following error occurred getting the existing index names: {error}',
        values: {
          error: (0, _mlErrorUtils.extractErrorMessage)(e)
        }
      }));
    }
  }, 400);
  const debouncedJobIdCheck = (0, _react.useMemo)(() => (0, _lodash.debounce)(async () => {
    try {
      const results = await _ml_api_service.ml.dataFrameAnalytics.jobsExist([jobId], true);
      setFormState({
        jobIdExists: results[jobId].exists
      });
    } catch (e) {
      notifications.toasts.addDanger(_i18n.i18n.translate('xpack.ml.dataframe.analytics.create.errorCheckingJobIdExists', {
        defaultMessage: 'The following error occurred checking if job id exists: {error}',
        values: {
          error: (0, _mlErrorUtils.extractErrorMessage)(e)
        }
      }));
    }
  }, 400),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [jobId]);
  (0, _react.useEffect)(() => {
    if (jobIdValid === true) {
      debouncedJobIdCheck();
    } else if (typeof jobId === 'string' && jobId.trim() === '' && jobIdExists === true) {
      setFormState({
        jobIdExists: false
      });
    }
    return () => {
      debouncedJobIdCheck.cancel();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobId]);
  (0, _react.useEffect)(() => {
    if (destinationIndexNameValid === true) {
      debouncedIndexCheck();
    } else if (typeof destinationIndex === 'string' && destinationIndex.trim() === '' && destinationIndexNameExists === true) {
      setFormState({
        destinationIndexNameExists: false
      });
    }
    return () => {
      debouncedIndexCheck.cancel();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [destinationIndex]);
  (0, _react.useEffect)(() => {
    if (destIndexSameAsId === true && !jobIdEmpty && jobIdValid) {
      setFormState({
        destinationIndex: jobId
      });
    } else if (destIndexSameAsId === false && hasSwitchedToEditor === false) {
      setFormState({
        destinationIndex: ''
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [destIndexSameAsId, jobId]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.jobIdLabel', {
      defaultMessage: 'Job ID'
    }),
    isInvalid: !jobIdEmpty && !jobIdValid || jobIdExists || jobIdInvalidMaxLength,
    error: [...(!jobIdEmpty && !jobIdValid ? [_i18n.i18n.translate('xpack.ml.dataframe.analytics.create.jobIdInvalidError', {
      defaultMessage: 'Must contain lowercase alphanumeric characters (a-z and 0-9), hyphens, and underscores only and must start and end with alphanumeric characters.'
    })] : []), ...(jobIdExists ? [_i18n.i18n.translate('xpack.ml.dataframe.analytics.create.jobIdExistsError', {
      defaultMessage: 'An analytics job with this ID already exists.'
    })] : []), ...(jobIdInvalidMaxLength ? [_i18n.i18n.translate('xpack.ml.dataframe.analytics.create.jobIdInvalidMaxLengthErrorMessage', {
      defaultMessage: 'Job ID must be no more than {maxLength, plural, one {# character} other {# characters}} long.',
      values: {
        maxLength: _validation.JOB_ID_MAX_LENGTH
      }
    })] : [])]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    inputRef: input => {
      if (input) {
        forceInput.current = input;
      }
    },
    disabled: isJobCreated,
    placeholder: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.jobIdPlaceholder', {
      defaultMessage: 'Job ID'
    }),
    value: jobId,
    onChange: e => setFormState({
      jobId: e.target.value
    }),
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.jobIdInputAriaLabel', {
      defaultMessage: 'Choose a unique analytics job ID.'
    }),
    isInvalid: !jobIdEmpty && !jobIdValid || jobIdExists || jobIdEmpty,
    "data-test-subj": "mlAnalyticsCreateJobFlyoutJobIdInput"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.jobDescription.label', {
      defaultMessage: 'Job description'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    fullWidth: true,
    value: description,
    placeholder: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.jobDescription.helpText', {
      defaultMessage: 'Optional descriptive text'
    }),
    rows: 2,
    onChange: e => {
      const value = e.target.value;
      setFormState({
        description: value
      });
    },
    "data-test-subj": "mlDFAnalyticsJobCreationJobDescription"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: destIndexSameAsId === true && destinationIndexNameExists && indexNameExistsMessage
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    disabled: isJobCreated,
    name: "mlDataFrameAnalyticsDestIndexSameAsId",
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.DestIndexSameAsIdLabel', {
      defaultMessage: 'Destination index same as job ID'
    }),
    checked: destIndexSameAsId === true,
    onChange: () => setDestIndexSameAsId(!destIndexSameAsId),
    "data-test-subj": "mlAnalyticsCreateJobWizardDestIndexSameAsIdSwitch"
  })), destIndexSameAsId === false && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.destinationIndexLabel', {
      defaultMessage: 'Destination index'
    }),
    isInvalid: destinationIndexNameEmpty || !destinationIndexNameEmpty && !destinationIndexNameValid,
    helpText: destinationIndexNameExists && indexNameExistsMessage,
    error: !destinationIndexNameEmpty && !destinationIndexNameValid && [/*#__PURE__*/_react.default.createElement(_react.Fragment, null, _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.destinationIndexInvalidError', {
      defaultMessage: 'Invalid destination index name.'
    }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: createIndexLink,
      target: "_blank"
    }, _i18n.i18n.translate('xpack.ml.dataframe.stepDetailsForm.destinationIndexInvalidErrorLink', {
      defaultMessage: 'Learn more about index name limitations.'
    })))]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    disabled: isJobCreated,
    placeholder: "destination index",
    value: destinationIndex,
    onChange: e => setFormState({
      destinationIndex: e.target.value
    }),
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.destinationIndexInputAriaLabel', {
      defaultMessage: 'Choose a unique destination index name.'
    }),
    isInvalid: !destinationIndexNameEmpty && !destinationIndexNameValid,
    "data-test-subj": "mlAnalyticsCreateJobFlyoutDestinationIndexInput"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    disabled: isJobCreated,
    name: "mlDataFrameAnalyticsUseResultsFieldDefault",
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.UseResultsFieldDefaultLabel', {
      defaultMessage: 'Use results field default value: "{defaultValue}"',
      values: {
        defaultValue: DEFAULT_RESULTS_FIELD
      }
    }),
    checked: useResultsFieldDefault === true,
    onChange: () => {
      if (!useResultsFieldDefault === true) {
        setFormState({
          resultsField: undefined
        });
      }
      setUseResultsFieldDefault(!useResultsFieldDefault);
    },
    "data-test-subj": "mlAnalyticsCreateJobWizardUseResultsFieldDefault"
  })), useResultsFieldDefault === false && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.resultsFieldLabel', {
      defaultMessage: 'Results field'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.resultsFieldHelpText', {
      defaultMessage: 'Define the name of the field in which to store the results of the analysis. Defaults to ml.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    disabled: isJobCreated,
    placeholder: "Results field",
    value: resultsField,
    onChange: e => setFormState({
      resultsField: e.target.value
    }),
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.resultsFieldInputAriaLabel', {
      defaultMessage: 'The name of the field in which to store the results of the analysis.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardResultsFieldInput"
  })), destinationIndexNameValid && dataViewAvailableTimeFields.length > 0 ? /*#__PURE__*/_react.default.createElement(_details_step_time_field.DetailsStepTimeField, {
    dataViewAvailableTimeFields: dataViewAvailableTimeFields,
    dataViewTimeField: timeFieldName,
    onTimeFieldChanged: onTimeFieldChanged
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_continue_button.ContinueButton, {
    isDisabled: isStepInvalid,
    onClick: () => {
      setCurrentStep(_page.ANALYTICS_STEPS.VALIDATION);
    }
  }));
};
exports.DetailsStepForm = DetailsStepForm;