"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProgressStats = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProgressStats = ({
  currentProgress,
  failedJobMessage
}) => {
  if (currentProgress === undefined) return null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), failedJobMessage !== undefined && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "analyticsWizardProgressCallout",
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.analyticsProgressCalloutTitle', {
      defaultMessage: 'Job failed'
    }),
    color: 'danger',
    iconType: 'error',
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, failedJobMessage)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.analyticsProgressTitle', {
    defaultMessage: 'Progress'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.analyticsProgressPhaseTitle', {
    defaultMessage: 'Phase'
  }), ' ', currentProgress.currentPhase, "/", currentProgress.totalPhases))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: '400px'
    },
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    value: currentProgress.progress,
    max: 100,
    color: "primary",
    size: "l",
    "data-test-subj": "mlAnalyticsCreationWizardProgress"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, `${currentProgress.progress}%`))));
};
exports.ProgressStats = ProgressStats;