"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PROGRESS_REFRESH_INTERVAL_MS = exports.CreateStepFooter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("../../../analytics_management/components/analytics_list/common");
var _get_analytics = require("../../../analytics_management/services/analytics_service/get_analytics");
var _kibana = require("../../../../../contexts/kibana");
var _ml_api_service = require("../../../../../services/ml_api_service");
var _back_to_list_panel = require("../back_to_list_panel");
var _view_results_panel = require("../view_results_panel");
var _progress_stats = require("./progress_stats");
var _jobs_awaiting_node_warning = require("../../../../../components/jobs_awaiting_node_warning");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PROGRESS_REFRESH_INTERVAL_MS = 1000;
exports.PROGRESS_REFRESH_INTERVAL_MS = PROGRESS_REFRESH_INTERVAL_MS;
const CreateStepFooter = ({
  jobId,
  jobType,
  showProgress
}) => {
  const [initialized, setInitialized] = (0, _react.useState)(false);
  const [failedJobMessage, setFailedJobMessage] = (0, _react.useState)(undefined);
  const [jobFinished, setJobFinished] = (0, _react.useState)(false);
  const [currentProgress, setCurrentProgress] = (0, _react.useState)(undefined);
  const [showJobAssignWarning, setShowJobAssignWarning] = (0, _react.useState)(false);
  const {
    services: {
      notifications
    }
  } = (0, _kibana.useMlKibana)();
  (0, _react.useEffect)(() => {
    setInitialized(true);
  }, []);
  (0, _react.useEffect)(() => {
    if (showProgress === false) return;
    const interval = setInterval(async () => {
      try {
        const analyticsStats = await _ml_api_service.ml.dataFrameAnalytics.getDataFrameAnalyticsStats(jobId);
        const jobStats = (0, _get_analytics.isGetDataFrameAnalyticsStatsResponseOk)(analyticsStats) ? analyticsStats.data_frame_analytics[0] : undefined;
        setShowJobAssignWarning((jobStats === null || jobStats === void 0 ? void 0 : jobStats.state) === _common.DATA_FRAME_TASK_STATE.STARTING && (jobStats === null || jobStats === void 0 ? void 0 : jobStats.node) === undefined);
        if (jobStats !== undefined) {
          const progressStats = (0, _common.getDataFrameAnalyticsProgressPhase)(jobStats);
          if (jobStats.state === _common.DATA_FRAME_TASK_STATE.FAILED) {
            clearInterval(interval);
            setFailedJobMessage(jobStats.failure_reason || _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.analyticsProgressCalloutMessage', {
              defaultMessage: 'Analytics job {jobId} has failed.',
              values: {
                jobId
              }
            }));
          }
          setCurrentProgress(progressStats);
          // Clear if job is completed or stopped (after having started)
          if (progressStats.currentPhase === progressStats.totalPhases && progressStats.progress === 100 || jobStats.state === _common.DATA_FRAME_TASK_STATE.STOPPED && !(progressStats.currentPhase === 1 && progressStats.progress === 0)) {
            clearInterval(interval);
            // Check job has started. Jobs that fail to start will also have STOPPED state
            setJobFinished(progressStats.currentPhase === progressStats.totalPhases && progressStats.progress === 100);
          }
        } else {
          clearInterval(interval);
        }
      } catch (e) {
        notifications.toasts.addDanger(_i18n.i18n.translate('xpack.ml.dataframe.analytics.create.analyticsProgressErrorMessage', {
          defaultMessage: 'An error occurred getting progress stats for analytics job {jobId}',
          values: {
            jobId
          }
        }));
        clearInterval(interval);
      }
    }, PROGRESS_REFRESH_INTERVAL_MS);
    return () => clearInterval(interval);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [initialized]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showJobAssignWarning && /*#__PURE__*/_react.default.createElement(_jobs_awaiting_node_warning.NewJobAwaitingNodeWarning, {
    jobType: "data-frame-analytics"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, showProgress && /*#__PURE__*/_react.default.createElement(_progress_stats.ProgressStats, {
    currentProgress: currentProgress,
    failedJobMessage: failedJobMessage
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_back_to_list_panel.BackToListPanel, null)), jobFinished === true ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_view_results_panel.ViewResultsPanel, {
    jobId: jobId,
    analysisType: jobType
  })) : null))));
};
exports.CreateStepFooter = CreateStepFooter;