"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../../contexts/kibana");
var _shared = require("../shared");
var _page = require("../../page");
var _create_step_footer = require("../create_step_footer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateStep = ({
  actions,
  state,
  step
}) => {
  const {
    services: {
      application: {
        capabilities
      }
    }
  } = (0, _kibana.useMlKibana)();
  const canCreateDataView = (0, _react.useMemo)(() => capabilities.savedObjectsManagement.edit === true || capabilities.indexPatterns.save === true, [capabilities]);
  const {
    createAnalyticsJob,
    setFormState,
    startAnalyticsJob
  } = actions;
  const {
    isAdvancedEditorValidJson,
    isJobCreated,
    isJobStarted,
    isValid,
    requestMessages
  } = state;
  const {
    createIndexPattern,
    destinationIndex,
    destinationIndexPatternTitleExists,
    jobId,
    jobType
  } = state.form;
  const [startChecked, setStartChecked] = (0, _react.useState)(true);
  const [creationTriggered, setCreationTriggered] = (0, _react.useState)(false);
  const [showProgress, setShowProgress] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (canCreateDataView === false) {
      setFormState({
        createIndexPattern: false
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [capabilities]);
  if (step !== _page.ANALYTICS_STEPS.CREATE) return null;
  const handleCreation = async () => {
    setCreationTriggered(true);
    const creationSuccess = await createAnalyticsJob();
    if (creationSuccess === false) {
      setCreationTriggered(false);
    }
    if (startChecked && creationSuccess === true) {
      setShowProgress(true);
      startAnalyticsJob();
    }
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlAnalyticsCreateJobWizardCreateStep active"
  }, !isJobCreated && !isJobStarted && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.startCheckboxHelpText', {
      defaultMessage: 'If unselected, job can be started later by returning to the jobs list.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "data-test-subj": "mlAnalyticsCreateJobWizardStartJobCheckbox",
    id: 'dataframe-create-start-checkbox',
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.wizardStartCheckbox', {
      defaultMessage: 'Start immediately'
    }),
    checked: startChecked,
    onChange: e => {
      setStartChecked(e.target.checked);
      if (e.target.checked === false) {
        setFormState({
          createIndexPattern: false
        });
      }
    }
  }))), startChecked ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: createIndexPattern && destinationIndexPatternTitleExists || createIndexPattern === false || canCreateDataView === false,
    error: [...(canCreateDataView === false ? [/*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "warning"
    }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.dataViewPermissionWarning', {
      defaultMessage: 'You need permission to create data views.'
    }))] : []), ...(createIndexPattern && destinationIndexPatternTitleExists ? [_i18n.i18n.translate('xpack.ml.dataframe.analytics.create.dataViewExistsError', {
      defaultMessage: 'A data view with the title {title} already exists.',
      values: {
        title: destinationIndex
      }
    })] : []), ...(!createIndexPattern && !destinationIndexPatternTitleExists ? [/*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "warning"
    }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.shouldCreateDataViewMessage', {
      defaultMessage: 'You may not be able to view job results if a data view is not created for the destination index.'
    }))] : [])]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    disabled: isJobCreated || canCreateDataView === false,
    name: "mlDataFrameAnalyticsCreateIndexPattern",
    id: 'dataframe-create-data-view-checkbox',
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.createDataViewLabel', {
      defaultMessage: 'Create data view'
    }),
    checked: createIndexPattern === true,
    onChange: () => setFormState({
      createIndexPattern: !createIndexPattern
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardCreateIndexPatternCheckbox"
  }))) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    className: "mlAnalyticsCreateWizard__footerButton",
    disabled: !isValid || !isAdvancedEditorValidJson || destinationIndexPatternTitleExists === true && createIndexPattern === true,
    onClick: handleCreation,
    fill: true,
    isLoading: creationTriggered,
    "data-test-subj": "mlAnalyticsCreateJobWizardCreateButton"
  }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.wizardCreateButton', {
    defaultMessage: 'Create'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_shared.Messages, {
    messages: requestMessages
  }), isJobCreated === true ? /*#__PURE__*/_react.default.createElement(_create_step_footer.CreateStepFooter, {
    jobId: jobId,
    jobType: jobType,
    showProgress: showProgress
  }) : null);
};
exports.CreateStep = CreateStep;