"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSavedSearch = useSavedSearch;
var _react = require("react");
var _esQuery = require("@kbn/es-query");
var _ml = require("../../../../../contexts/ml");
var _search = require("../../../../../../../common/constants/search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useSavedSearch() {
  const [savedSearchQuery, setSavedSearchQuery] = (0, _react.useState)(undefined);
  const [savedSearchQueryStr, setSavedSearchQueryStr] = (0, _react.useState)(undefined);
  const mlContext = (0, _ml.useMlContext)();
  const {
    currentDataView,
    kibanaConfig,
    selectedSavedSearch
  } = mlContext;
  const getQueryData = () => {
    let qry = {};
    let qryString;
    if (selectedSavedSearch) {
      var _selectedSavedSearch$;
      // FIXME: Add support for AggregateQuery type #150091
      const query = selectedSavedSearch.searchSource.getField('query');
      const filter = (_selectedSavedSearch$ = selectedSavedSearch.searchSource.getField('filter')) !== null && _selectedSavedSearch$ !== void 0 ? _selectedSavedSearch$ : [];
      const queryLanguage = query.language;
      qryString = query.query;
      if (queryLanguage === _search.SEARCH_QUERY_LANGUAGE.KUERY) {
        const ast = (0, _esQuery.fromKueryExpression)(qryString);
        qry = (0, _esQuery.toElasticsearchQuery)(ast, currentDataView);
        const filterQuery = (0, _esQuery.buildQueryFromFilters)(filter, currentDataView);
        if (qry.bool === undefined) {
          qry.bool = {};
          // toElasticsearchQuery may add a single match_all item to the
          // root of its returned query, rather than putting it inside
          // a bool.should
          // in this case, move it to a bool.should
          if (qry.match_all !== undefined) {
            qry.bool.should = {
              match_all: qry.match_all
            };
            delete qry.match_all;
          }
        }
        if (Array.isArray(qry.bool.filter) === false) {
          qry.bool.filter = qry.bool.filter === undefined ? [] : [qry.bool.filter];
        }
        if (Array.isArray(qry.bool.must_not) === false) {
          qry.bool.must_not = qry.bool.must_not === undefined ? [] : [qry.bool.must_not];
        }
        qry.bool.filter = [...qry.bool.filter, ...filterQuery.filter];
        qry.bool.must_not = [...qry.bool.must_not, ...filterQuery.must_not];
      } else {
        qry = (0, _esQuery.buildEsQuery)(currentDataView, [query], filter);
        (0, _esQuery.decorateQuery)(qry, kibanaConfig.get('query:queryString:options'));
      }
      setSavedSearchQuery(qry);
      setSavedSearchQueryStr(qryString);
    } else {
      setSavedSearchQuery(null);
      setSavedSearchQueryStr(null);
    }
  };
  (0, _react.useEffect)(() => {
    getQueryData();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return {
    savedSearchQuery,
    savedSearchQueryStr
  };
}