"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SupportedFieldsMessage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _fieldTypes = require("@kbn/field-types");
var _analytics = require("../../../../common/analytics");
var _fields = require("../../../../../../../common/types/fields");
var _field_types = require("../../../../../../../common/constants/field_types");
var _fields2 = require("../../../../common/fields");
var _form_options_validation = require("./form_options_validation");
var _new_job_capabilities_service_analytics = require("../../../../../services/new_job_capabilities/new_job_capabilities_service_analytics");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const containsClassificationFieldsCb = ({
  name,
  type
}) => !_field_types.OMIT_FIELDS.includes(name) && name !== _fields.EVENT_RATE_FIELD_ID && (_fields2.BASIC_NUMERICAL_TYPES.has(type) || _form_options_validation.CATEGORICAL_TYPES.has(type) || type === _fieldTypes.ES_FIELD_TYPES.BOOLEAN);
const containsRegressionFieldsCb = ({
  name,
  type
}) => !_field_types.OMIT_FIELDS.includes(name) && name !== _fields.EVENT_RATE_FIELD_ID && (_fields2.BASIC_NUMERICAL_TYPES.has(type) || _fields2.EXTENDED_NUMERICAL_TYPES.has(type));
const containsOutlierFieldsCb = ({
  name,
  type
}) => !_field_types.OMIT_FIELDS.includes(name) && name !== _fields.EVENT_RATE_FIELD_ID && (_fields2.BASIC_NUMERICAL_TYPES.has(type) || _fields2.EXTENDED_NUMERICAL_TYPES.has(type));
const callbacks = {
  [_analytics.ANALYSIS_CONFIG_TYPE.CLASSIFICATION]: containsClassificationFieldsCb,
  [_analytics.ANALYSIS_CONFIG_TYPE.REGRESSION]: containsRegressionFieldsCb,
  [_analytics.ANALYSIS_CONFIG_TYPE.OUTLIER_DETECTION]: containsOutlierFieldsCb
};
const messages = {
  [_analytics.ANALYSIS_CONFIG_TYPE.CLASSIFICATION]: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.create.sourceObjectClassificationHelpText",
    defaultMessage: "This data view does not contain any supported fields. Classification jobs require categorical, numeric, or boolean fields."
  }),
  [_analytics.ANALYSIS_CONFIG_TYPE.REGRESSION]: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.create.sourceObjectRegressionHelpText",
    defaultMessage: "This data view does not contain any supported fields. Regression jobs require numeric fields."
  }),
  [_analytics.ANALYSIS_CONFIG_TYPE.OUTLIER_DETECTION]: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.create.sourceObjectHelpText",
    defaultMessage: "This data view does not contain any numeric type fields. The analytics job may not be able to come up with any outliers."
  })
};
const SupportedFieldsMessage = ({
  jobType
}) => {
  const [sourceIndexContainsSupportedFields, setSourceIndexContainsSupportedFields] = (0, _react.useState)(true);
  const [sourceIndexFieldsCheckFailed, setSourceIndexFieldsCheckFailed] = (0, _react.useState)(false);
  const {
    fields
  } = _new_job_capabilities_service_analytics.newJobCapsServiceAnalytics;

  // Find out if data view contains supported fields for job type. Provides a hint in the form
  // that job may not run correctly if no supported fields are found.
  const validateFields = () => {
    if (fields && jobType !== undefined) {
      try {
        const containsSupportedFields = fields.some(callbacks[jobType]);
        setSourceIndexContainsSupportedFields(containsSupportedFields);
        setSourceIndexFieldsCheckFailed(false);
      } catch (e) {
        setSourceIndexFieldsCheckFailed(true);
      }
    }
  };
  (0, _react.useEffect)(() => {
    if (jobType !== undefined) {
      validateFields();
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobType]);
  if (sourceIndexContainsSupportedFields === true) return null;
  if (sourceIndexFieldsCheckFailed === true) {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.create.sourceIndexFieldsCheckError",
      defaultMessage: "There was a problem checking for supported fields for job type. Please refresh the page and try again."
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "danger"
  }, jobType !== undefined && messages[jobType]), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
};
exports.SupportedFieldsMessage = SupportedFieldsMessage;