"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldAddAsDepVarOption = exports.handleExplainErrorMessage = exports.CATEGORICAL_TYPES = void 0;
var _i18n = require("@kbn/i18n");
var _fieldTypes = require("@kbn/field-types");
var _fields = require("../../../../../../../common/types/fields");
var _analytics = require("../../../../common/analytics");
var _fields2 = require("../../../../common/fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CATEGORICAL_TYPES = new Set(['ip', 'keyword']);

// Regression supports numeric fields. Classification supports categorical, numeric, and boolean.
exports.CATEGORICAL_TYPES = CATEGORICAL_TYPES;
const shouldAddAsDepVarOption = (fieldId, fieldType, jobType) => {
  if (fieldId === _fields.EVENT_RATE_FIELD_ID) return false;
  const isBasicNumerical = _fields2.BASIC_NUMERICAL_TYPES.has(fieldType);
  const isSupportedByClassification = isBasicNumerical || CATEGORICAL_TYPES.has(fieldType) || fieldType === _fieldTypes.ES_FIELD_TYPES.BOOLEAN;
  if (jobType === _analytics.ANALYSIS_CONFIG_TYPE.REGRESSION) {
    return isBasicNumerical || _fields2.EXTENDED_NUMERICAL_TYPES.has(fieldType);
  }
  if (jobType === _analytics.ANALYSIS_CONFIG_TYPE.CLASSIFICATION) return isSupportedByClassification;
};
exports.shouldAddAsDepVarOption = shouldAddAsDepVarOption;
const handleExplainErrorMessage = (errorMessage, sourceIndex, jobType) => {
  let maxDistinctValuesErrorMessage;
  let unsupportedFieldsErrorMessage;
  let toastNotificationWarning;
  let toastNotificationDanger;
  if (jobType === _analytics.ANALYSIS_CONFIG_TYPE.CLASSIFICATION && (errorMessage.includes('must have at most') || errorMessage.includes('must have at least'))) {
    maxDistinctValuesErrorMessage = errorMessage;
  } else if (errorMessage.includes('status_exception') && errorMessage.includes('unsupported type')) {
    unsupportedFieldsErrorMessage = errorMessage;
  } else if (errorMessage.includes('status_exception') && errorMessage.includes('Unable to estimate memory usage as no documents')) {
    toastNotificationWarning = _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.allDocsMissingFieldsErrorMessage', {
      defaultMessage: `Unable to estimate memory usage. There are mapped fields for source index [{index}] that do not exist in any indexed documents. You will have to switch to the JSON editor for explicit field selection and include only fields that exist in indexed documents.`,
      values: {
        index: sourceIndex
      }
    });
  } else {
    toastNotificationDanger = {
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.unableToFetchExplainDataMessage', {
        defaultMessage: 'An error occurred fetching analysis fields data.'
      }),
      text: errorMessage
    };
  }
  return {
    maxDistinctValuesErrorMessage,
    unsupportedFieldsErrorMessage,
    toastNotificationDanger,
    toastNotificationWarning
  };
};
exports.handleExplainErrorMessage = handleExplainErrorMessage;