"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigurationStepDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _state = require("../../../analytics_management/hooks/use_create_analytics_form/state");
var _analytics = require("../../../../common/analytics");
var _ml = require("../../../../../contexts/ml");
var _page = require("../../page");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_INCLUDES_LENGTH = 5;
const ConfigurationStepDetails = ({
  setCurrentStep,
  state
}) => {
  const mlContext = (0, _ml.useMlContext)();
  const {
    currentDataView
  } = mlContext;
  const {
    form,
    isJobCreated
  } = state;
  const {
    dependentVariable,
    includes,
    jobConfigQueryString,
    jobType,
    trainingPercent
  } = form;
  const isJobTypeWithDepVar = jobType === _analytics.ANALYSIS_CONFIG_TYPE.REGRESSION || jobType === _analytics.ANALYSIS_CONFIG_TYPE.CLASSIFICATION;
  const detailsFirstCol = [{
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.sourceIndex', {
      defaultMessage: 'Source index'
    }),
    description: currentDataView.title || _state.UNSET_CONFIG_ITEM
  }, {
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.Query', {
      defaultMessage: 'Query'
    }),
    description: jobConfigQueryString || _state.UNSET_CONFIG_ITEM
  }];
  const detailsSecondCol = [{
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.jobType', {
      defaultMessage: 'Job type'
    }),
    description: jobType
  }];
  const detailsThirdCol = [{
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.includedFields', {
      defaultMessage: 'Included fields'
    }),
    description: includes.length > MAX_INCLUDES_LENGTH ? _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.includedFieldsAndMoreDescription', {
      defaultMessage: '{includedFields} ... (and {extraCount} more)',
      values: {
        extraCount: includes.length - MAX_INCLUDES_LENGTH,
        includedFields: includes.slice(0, MAX_INCLUDES_LENGTH).join(', ')
      }
    }) : includes.join(', ')
  }];
  if (isJobTypeWithDepVar) {
    detailsSecondCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.trainingPercent', {
        defaultMessage: 'Training percent'
      }),
      description: `${trainingPercent}`
    });
    detailsThirdCol.unshift({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.dependentVariable', {
        defaultMessage: 'Dependent variable'
      }),
      description: dependentVariable
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      width: '70%'
    },
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: detailsFirstCol
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: detailsSecondCol
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: detailsThirdCol
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), !isJobCreated && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "pencil",
    size: "s",
    onClick: () => {
      setCurrentStep(_page.ANALYTICS_STEPS.CONFIGURATION);
    }
  }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.editButtonText', {
    defaultMessage: 'Edit'
  })));
};
exports.ConfigurationStepDetails = ConfigurationStepDetails;