"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HyperParameters = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _advanced_step_form = require("./advanced_step_form");
var _analytics = require("../../../../common/analytics");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_TREES_LIMIT = 2000;
const HyperParameters = ({
  actions,
  state,
  advancedParamErrors
}) => {
  const {
    setFormState
  } = actions;
  const {
    alpha,
    downsampleFactor,
    eta,
    etaGrowthRatePerTree,
    featureBagFraction,
    gamma,
    lambda,
    maxOptimizationRoundsPerHyperparameter,
    maxTrees,
    softTreeDepthLimit,
    softTreeDepthTolerance
  } = state.form;
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.lambdaLabel', {
      defaultMessage: 'Lambda'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.lambdaHelpText', {
      defaultMessage: 'A multiplier of the leaf weights in loss calculations. Must be a nonnegative value.'
    }),
    isInvalid: advancedParamErrors[_analytics.ANALYSIS_ADVANCED_FIELDS.LAMBDA] !== undefined,
    error: advancedParamErrors[_analytics.ANALYSIS_ADVANCED_FIELDS.LAMBDA]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.lambdaInputAriaLabel', {
      defaultMessage: 'A multiplier of leaf weights in loss calculations.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobFlyoutLambdaInput",
    onChange: e => setFormState({
      lambda: e.target.value === '' ? undefined : +e.target.value
    }),
    step: 0.001,
    min: 0,
    value: (0, _advanced_step_form.getNumberValue)(lambda)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.maxTreesLabel', {
      defaultMessage: 'Max trees'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.maxTreesText', {
      defaultMessage: 'The maximum number of decision trees in the forest.'
    }),
    isInvalid: advancedParamErrors[_analytics.ANALYSIS_ADVANCED_FIELDS.MAX_TREES] !== undefined,
    error: advancedParamErrors[_analytics.ANALYSIS_ADVANCED_FIELDS.MAX_TREES]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.maxTreesInputAriaLabel', {
      defaultMessage: 'The maximum number of decision trees in the forest.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobFlyoutMaxTreesInput",
    onChange: e => setFormState({
      maxTrees: e.target.value === '' ? undefined : +e.target.value
    }),
    isInvalid: maxTrees !== undefined && !Number.isInteger(maxTrees),
    step: 1,
    min: 1,
    max: MAX_TREES_LIMIT,
    value: (0, _advanced_step_form.getNumberValue)(maxTrees)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.gammaLabel', {
      defaultMessage: 'Gamma'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.gammaText', {
      defaultMessage: 'A multiplier of the tree size in loss calcuations. Must be nonnegative value.'
    }),
    isInvalid: advancedParamErrors[_analytics.ANALYSIS_ADVANCED_FIELDS.GAMMA] !== undefined,
    error: advancedParamErrors[_analytics.ANALYSIS_ADVANCED_FIELDS.GAMMA]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.gammaInputAriaLabel', {
      defaultMessage: 'A multiplier of the tree size in loss calculations.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardGammaInput",
    onChange: e => setFormState({
      gamma: e.target.value === '' ? undefined : +e.target.value
    }),
    step: 0.001,
    min: 0,
    value: (0, _advanced_step_form.getNumberValue)(gamma)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.etaLabel', {
      defaultMessage: 'Eta'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.etaText', {
      defaultMessage: 'The shrinkage applied to the weights. Must be between 0.001 and 1.'
    }),
    isInvalid: advancedParamErrors[_analytics.ANALYSIS_ADVANCED_FIELDS.ETA] !== undefined,
    error: advancedParamErrors[_analytics.ANALYSIS_ADVANCED_FIELDS.ETA]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.etaInputAriaLabel', {
      defaultMessage: 'The shrinkage applied to the weights.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardEtaInput",
    onChange: e => setFormState({
      eta: e.target.value === '' ? undefined : +e.target.value
    }),
    step: 0.001,
    min: 0.001,
    max: 1,
    value: (0, _advanced_step_form.getNumberValue)(eta)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.featureBagFractionLabel', {
      defaultMessage: 'Feature bag fraction'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.featureBagFractionText', {
      defaultMessage: 'The fraction of features used when selecting a random bag for each candidate split.'
    }),
    isInvalid: advancedParamErrors[_analytics.ANALYSIS_ADVANCED_FIELDS.FEATURE_BAG_FRACTION] !== undefined,
    error: advancedParamErrors[_analytics.ANALYSIS_ADVANCED_FIELDS.FEATURE_BAG_FRACTION]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.featureBagFractionInputAriaLabel', {
      defaultMessage: 'The fraction of features used when selecting a random bag for each candidate split'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardFeatureBagFractionInput",
    onChange: e => setFormState({
      featureBagFraction: e.target.value === '' ? undefined : +e.target.value
    }),
    isInvalid: featureBagFraction !== undefined && (featureBagFraction > 1 || featureBagFraction <= 0),
    step: 0.001,
    max: 1,
    value: (0, _advanced_step_form.getNumberValue)(featureBagFraction)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.alphaLabel', {
      defaultMessage: 'Alpha'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.alphaText', {
      defaultMessage: 'A multiplier of the tree depth in loss calculations. Must be greater than or equal to 0.'
    }),
    isInvalid: advancedParamErrors[_analytics.ANALYSIS_ADVANCED_FIELDS.ALPHA] !== undefined,
    error: advancedParamErrors[_analytics.ANALYSIS_ADVANCED_FIELDS.ALPHA]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.alphaInputAriaLabel', {
      defaultMessage: 'A multiplier of the tree depth in loss calculations.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardAlphaInput",
    onChange: e => setFormState({
      alpha: e.target.value === '' ? undefined : +e.target.value
    }),
    step: 0.001,
    min: 0,
    value: (0, _advanced_step_form.getNumberValue)(alpha)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.downsampleFactorLabel', {
      defaultMessage: 'Downsample factor'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.downsampleFactorText', {
      defaultMessage: 'The fraction of data used to compute derivatives of the loss function for tree training. Must be between 0 and 1.'
    }),
    isInvalid: advancedParamErrors[_analytics.ANALYSIS_ADVANCED_FIELDS.DOWNSAMPLE_FACTOR] !== undefined,
    error: advancedParamErrors[_analytics.ANALYSIS_ADVANCED_FIELDS.DOWNSAMPLE_FACTOR]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.downsampleFactorInputAriaLabel', {
      defaultMessage: 'The fraction of data used to compute derivatives of the loss function for tree training.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardDownsampleFactorInput",
    onChange: e => setFormState({
      downsampleFactor: e.target.value === '' ? undefined : +e.target.value
    }),
    step: 0.001,
    min: 0,
    max: 1,
    value: (0, _advanced_step_form.getNumberValue)(downsampleFactor)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.etaGrowthRatePerTreeLabel', {
      defaultMessage: 'Eta growth rate per tree'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.etaGrowthRatePerTreeText', {
      defaultMessage: 'The rate at which eta increases for each new tree that is added to the forest. Must be between 0.5 and 2.'
    }),
    isInvalid: advancedParamErrors[_analytics.ANALYSIS_ADVANCED_FIELDS.ETA_GROWTH_RATE_PER_TREE] !== undefined,
    error: advancedParamErrors[_analytics.ANALYSIS_ADVANCED_FIELDS.ETA_GROWTH_RATE_PER_TREE]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.etaGrowthRatePerTreeInputAriaLabel', {
      defaultMessage: 'The rate at which eta increases for each new tree that is added to the forest.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardEtaGrowthRatePerTreeInput",
    onChange: e => setFormState({
      etaGrowthRatePerTree: e.target.value === '' ? undefined : +e.target.value
    }),
    step: 0.001,
    min: 0.5,
    max: 2,
    value: (0, _advanced_step_form.getNumberValue)(etaGrowthRatePerTree)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.maxOptimizationRoundsPerHyperparameterLabel', {
      defaultMessage: 'Max optimization rounds per hyperparameter'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.maxOptimizationRoundsPerHyperparameterText', {
      defaultMessage: 'The maximum number of optimization rounds for each undefined hyperparameter.'
    }),
    isInvalid: advancedParamErrors[_analytics.ANALYSIS_ADVANCED_FIELDS.MAX_OPTIMIZATION_ROUNDS_PER_HYPERPARAMETER] !== undefined,
    error: advancedParamErrors[_analytics.ANALYSIS_ADVANCED_FIELDS.MAX_OPTIMIZATION_ROUNDS_PER_HYPERPARAMETER]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.maxOptimizationRoundsPerHyperparameterInputAriaLabel', {
      defaultMessage: 'The maximum number of optimization rounds for each undefined hyperparameter. Must be an integer between 0 and 20.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardMaxOptimizationRoundsPerHyperparameterInput",
    onChange: e => setFormState({
      maxOptimizationRoundsPerHyperparameter: e.target.value === '' ? undefined : +e.target.value
    }),
    min: 0,
    max: 20,
    step: 1,
    value: (0, _advanced_step_form.getNumberValue)(maxOptimizationRoundsPerHyperparameter)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.softTreeDepthLimitLabel', {
      defaultMessage: 'Soft tree depth limit'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.softTreeDepthLimitText', {
      defaultMessage: 'Decision trees that exceed this depth are penalized in loss calculations. Must be greater than or equal to 0. '
    }),
    isInvalid: advancedParamErrors[_analytics.ANALYSIS_ADVANCED_FIELDS.SOFT_TREE_DEPTH_LIMIT] !== undefined,
    error: advancedParamErrors[_analytics.ANALYSIS_ADVANCED_FIELDS.SOFT_TREE_DEPTH_LIMIT]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.softTreeDepthLimitInputAriaLabel', {
      defaultMessage: 'Decision trees that exceed this depth are penalized in loss calculations.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardSoftTreeDepthLimitInput",
    onChange: e => setFormState({
      softTreeDepthLimit: e.target.value === '' ? undefined : +e.target.value
    }),
    step: 0.001,
    min: 0,
    value: (0, _advanced_step_form.getNumberValue)(softTreeDepthLimit)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.softTreeDepthToleranceLabel', {
      defaultMessage: 'Soft tree depth tolerance'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.softTreeDepthToleranceText', {
      defaultMessage: 'Control how quickly the loss increases when tree depths exceed soft limits. The smaller the value, the faster the loss increases. Must be greater than or equal to 0.01. '
    }),
    isInvalid: advancedParamErrors[_analytics.ANALYSIS_ADVANCED_FIELDS.SOFT_TREE_DEPTH_TOLERANCE] !== undefined,
    error: advancedParamErrors[_analytics.ANALYSIS_ADVANCED_FIELDS.SOFT_TREE_DEPTH_TOLERANCE]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.softTreeDepthToleranceInputAriaLabel', {
      defaultMessage: 'Decision trees that exceed this depth are penalized in loss calculations.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardSoftTreeDepthToleranceInput",
    onChange: e => setFormState({
      softTreeDepthTolerance: e.target.value === '' ? undefined : +e.target.value
    }),
    step: 0.001,
    min: 0.01,
    value: (0, _advanced_step_form.getNumberValue)(softTreeDepthTolerance)
  }))));
};
exports.HyperParameters = HyperParameters;