"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedStepDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _state = require("../../../analytics_management/hooks/use_create_analytics_form/state");
var _analytics = require("../../../../common/analytics");
var _page = require("../../page");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getStringValue(value) {
  return typeof value === 'number' ? `${value}` : _state.UNSET_CONFIG_ITEM;
}
const AdvancedStepDetails = ({
  setCurrentStep,
  state
}) => {
  const {
    form,
    isJobCreated
  } = state;
  const {
    computeFeatureInfluence,
    dependentVariable,
    eta,
    featureBagFraction,
    featureInfluenceThreshold,
    gamma,
    jobType,
    lambda,
    method,
    maxNumThreads,
    maxTrees,
    modelMemoryLimit,
    nNeighbors,
    numTopClasses,
    numTopFeatureImportanceValues,
    outlierFraction,
    predictionFieldName,
    randomizeSeed,
    standardizationEnabled
  } = form;
  const isRegOrClassJob = jobType === _analytics.ANALYSIS_CONFIG_TYPE.REGRESSION || jobType === _analytics.ANALYSIS_CONFIG_TYPE.CLASSIFICATION;
  const advancedFirstCol = [];
  const advancedSecondCol = [];
  const advancedThirdCol = [];
  const hyperFirstCol = [];
  const hyperSecondCol = [];
  const hyperThirdCol = [];
  if (jobType === _analytics.ANALYSIS_CONFIG_TYPE.OUTLIER_DETECTION) {
    advancedFirstCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.computeFeatureInfluence', {
        defaultMessage: 'Compute feature influence'
      }),
      description: computeFeatureInfluence
    });
    advancedSecondCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.featureInfluenceThreshold', {
        defaultMessage: 'Feature influence threshold'
      }),
      description: getStringValue(featureInfluenceThreshold)
    });
    advancedThirdCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.modelMemoryLimit', {
        defaultMessage: 'Model memory limit'
      }),
      description: `${modelMemoryLimit}`
    });
    hyperFirstCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.nNeighbors', {
        defaultMessage: 'N neighbors'
      }),
      description: getStringValue(nNeighbors)
    }, {
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.outlierFraction', {
        defaultMessage: 'Outlier fraction'
      }),
      description: getStringValue(outlierFraction)
    });
    hyperSecondCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.method', {
        defaultMessage: 'Method'
      }),
      description: method !== undefined ? method : _state.UNSET_CONFIG_ITEM
    });
    hyperThirdCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.standardizationEnabled', {
        defaultMessage: 'Standardization enabled'
      }),
      description: `${standardizationEnabled}`
    });
  }
  if (isRegOrClassJob) {
    advancedFirstCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.numTopFeatureImportanceValues', {
        defaultMessage: 'Top feature importance values'
      }),
      description: `${numTopFeatureImportanceValues}`
    });
    hyperFirstCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.lambdaFields', {
        defaultMessage: 'Lambda'
      }),
      description: getStringValue(lambda)
    }, {
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.eta', {
        defaultMessage: 'Eta'
      }),
      description: getStringValue(eta)
    });
    advancedSecondCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.predictionFieldName', {
        defaultMessage: 'Prediction field name'
      }),
      description: predictionFieldName ? predictionFieldName : `${dependentVariable}_prediction`
    }, {
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.randomizedSeed', {
        defaultMessage: 'Randomized seed'
      }),
      description: getStringValue(randomizeSeed)
    });
    hyperSecondCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.maxTreesFields', {
        defaultMessage: 'Max trees'
      }),
      description: getStringValue(maxTrees)
    }, {
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.featureBagFraction', {
        defaultMessage: 'Feature bag fraction'
      }),
      description: getStringValue(featureBagFraction)
    });
    advancedThirdCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.modelMemoryLimit', {
        defaultMessage: 'Model memory limit'
      }),
      description: `${modelMemoryLimit}`
    });
    hyperThirdCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.gamma', {
        defaultMessage: 'Gamma'
      }),
      description: getStringValue(gamma)
    });
  }
  if (jobType === _analytics.ANALYSIS_CONFIG_TYPE.CLASSIFICATION) {
    advancedThirdCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.numTopClasses', {
        defaultMessage: 'Top classes'
      }),
      description: numTopClasses === -1 ? _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.allClasses', {
        defaultMessage: 'All classes'
      }) : getStringValue(numTopClasses)
    });
  }
  if (maxNumThreads !== undefined) {
    advancedFirstCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.maxNumThreads', {
        defaultMessage: 'Maximum number of threads'
      }),
      description: `${maxNumThreads}`
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.advancedConfigDetailsTitle', {
    defaultMessage: 'Advanced configuration'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      width: '70%'
    },
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: advancedFirstCol
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: advancedSecondCol
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: advancedThirdCol
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.hyperParametersDetailsTitle', {
    defaultMessage: 'Hyperparameters'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      width: '70%'
    },
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: hyperFirstCol
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: hyperSecondCol
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: hyperThirdCol
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), !isJobCreated && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "pencil",
    size: "s",
    onClick: () => {
      setCurrentStep(_page.ANALYTICS_STEPS.ADVANCED);
    }
  }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.advancedDetails.editButtonText', {
    defaultMessage: 'Edit'
  })));
};
exports.AdvancedStepDetails = AdvancedStepDetails;