"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndexFields = void 0;
var _new_job_capabilities_service_analytics = require("../../services/new_job_capabilities/new_job_capabilities_service_analytics");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIndexFields = (jobConfig, needsDestIndexFields) => {
  const {
    fields
  } = _new_job_capabilities_service_analytics.newJobCapsServiceAnalytics;
  if (jobConfig !== undefined) {
    const {
      selectedFields: defaultSelected,
      docFields
    } = (0, _.getDefaultFieldsFromJobCaps)(fields, jobConfig, needsDestIndexFields);
    const types = {};
    const allFields = [];
    docFields.forEach(field => {
      types[field.id] = field.type;
      allFields.push(field.id);
    });
    return {
      defaultSelectedFields: defaultSelected.map(field => field.id),
      fieldTypes: types,
      tableFields: allFields
    };
  } else {
    return {
      defaultSelectedFields: [],
      fieldTypes: {},
      tableFields: []
    };
  }
};
exports.getIndexFields = getIndexFields;