"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortExplorationResultsFields = exports.isKeywordAndTextType = exports.getDefaultFieldsFromJobCaps = exports.ML__INCREMENTAL_ID = exports.ML__ID_COPY = exports.MAX_COLUMNS = exports.EXTENDED_NUMERICAL_TYPES = exports.DEFAULT_REGRESSION_COLUMNS = exports.BASIC_NUMERICAL_TYPES = void 0;
var _fieldTypes = require("@kbn/field-types");
var _analytics = require("./analytics");
var _analytics_utils = require("../../../../common/util/analytics_utils");
var _new_job_capabilities_service_analytics = require("../../services/new_job_capabilities/new_job_capabilities_service_analytics");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_COLUMNS = 10;
exports.MAX_COLUMNS = MAX_COLUMNS;
const DEFAULT_REGRESSION_COLUMNS = 8;
exports.DEFAULT_REGRESSION_COLUMNS = DEFAULT_REGRESSION_COLUMNS;
const BASIC_NUMERICAL_TYPES = new Set([_fieldTypes.ES_FIELD_TYPES.UNSIGNED_LONG, _fieldTypes.ES_FIELD_TYPES.LONG, _fieldTypes.ES_FIELD_TYPES.INTEGER, _fieldTypes.ES_FIELD_TYPES.SHORT, _fieldTypes.ES_FIELD_TYPES.BYTE]);
exports.BASIC_NUMERICAL_TYPES = BASIC_NUMERICAL_TYPES;
const EXTENDED_NUMERICAL_TYPES = new Set([_fieldTypes.ES_FIELD_TYPES.DOUBLE, _fieldTypes.ES_FIELD_TYPES.FLOAT, _fieldTypes.ES_FIELD_TYPES.HALF_FLOAT, _fieldTypes.ES_FIELD_TYPES.SCALED_FLOAT]);

// eslint-disable-next-line @typescript-eslint/naming-convention
exports.EXTENDED_NUMERICAL_TYPES = EXTENDED_NUMERICAL_TYPES;
const ML__ID_COPY = 'ml__id_copy';
// eslint-disable-next-line @typescript-eslint/naming-convention
exports.ML__ID_COPY = ML__ID_COPY;
const ML__INCREMENTAL_ID = 'ml__incremental_id';
exports.ML__INCREMENTAL_ID = ML__INCREMENTAL_ID;
const isKeywordAndTextType = fieldName => {
  var _fields$find;
  const {
    fields
  } = _new_job_capabilities_service_analytics.newJobCapsServiceAnalytics;
  const fieldType = (_fields$find = fields.find(field => field.name === fieldName)) === null || _fields$find === void 0 ? void 0 : _fields$find.type;
  let isBothTypes = false;

  // If it's a keyword type - check if it has a corresponding text type
  if (fieldType !== undefined && fieldType === _fieldTypes.ES_FIELD_TYPES.KEYWORD) {
    const field = _new_job_capabilities_service_analytics.newJobCapsServiceAnalytics.getFieldById(fieldName.replace(/\.keyword$/, ''));
    isBothTypes = field !== null && field.type === _fieldTypes.ES_FIELD_TYPES.TEXT;
  } else if (fieldType !== undefined && fieldType === _fieldTypes.ES_FIELD_TYPES.TEXT) {
    //   If text, check if has corresponding keyword type
    const field = _new_job_capabilities_service_analytics.newJobCapsServiceAnalytics.getFieldById(`${fieldName}.keyword`);
    isBothTypes = field !== null && field.type === _fieldTypes.ES_FIELD_TYPES.KEYWORD;
  }
  return isBothTypes;
};

// Used to sort columns:
// - Anchor on the left ml.outlier_score, ml.is_training, <predictedField>, <actual>
// - string based columns are moved to the left
// - feature_influence/feature_importance fields get moved next to the corresponding field column
// - overall fields get sorted alphabetically
exports.isKeywordAndTextType = isKeywordAndTextType;
const sortExplorationResultsFields = (a, b, jobConfig) => {
  const resultsField = jobConfig.dest.results_field;
  if ((0, _analytics_utils.isOutlierAnalysis)(jobConfig.analysis)) {
    if (a === `${resultsField}.${_constants.OUTLIER_SCORE}`) {
      return -1;
    }
    if (b === `${resultsField}.${_constants.OUTLIER_SCORE}`) {
      return 1;
    }
  }
  if ((0, _analytics_utils.isClassificationAnalysis)(jobConfig.analysis) || (0, _analytics_utils.isRegressionAnalysis)(jobConfig.analysis)) {
    const dependentVariable = (0, _analytics_utils.getDependentVar)(jobConfig.analysis);
    const predictedField = (0, _analytics_utils.getPredictedFieldName)(resultsField, jobConfig.analysis, true);
    if (a === `${resultsField}.is_training`) {
      return -1;
    }
    if (b === `${resultsField}.is_training`) {
      return 1;
    }
    if (a === predictedField) {
      return -1;
    }
    if (b === predictedField) {
      return 1;
    }
    if (a === dependentVariable || a === dependentVariable.replace(/\.keyword$/, '')) {
      return -1;
    }
    if (b === dependentVariable || b === dependentVariable.replace(/\.keyword$/, '')) {
      return 1;
    }
    if (a === `${resultsField}.prediction_probability`) {
      return -1;
    }
    if (b === `${resultsField}.prediction_probability`) {
      return 1;
    }
  }
  const typeofA = typeof a;
  const typeofB = typeof b;
  const tokensA = a.split('.');
  const prefixA = tokensA[0];
  const tokensB = b.split('.');
  const prefixB = tokensB[0];
  if (prefixA === resultsField && tokensA.length > 1 && prefixB !== resultsField) {
    tokensA.shift();
    tokensA.shift();
    if (tokensA.join('.') === b) return 1;
    return tokensA.join('.').localeCompare(b);
  }
  if (prefixB === resultsField && tokensB.length > 1 && prefixA !== resultsField) {
    tokensB.shift();
    tokensB.shift();
    if (tokensB.join('.') === a) return -1;
    return a.localeCompare(tokensB.join('.'));
  }
  if (typeofA !== 'string' && typeofB === 'string') {
    return 1;
  }
  if (typeofA === 'string' && typeofB !== 'string') {
    return -1;
  }
  if (typeofA === 'string' && typeofB === 'string') {
    return a.localeCompare(b);
  }
  return a.localeCompare(b);
};
exports.sortExplorationResultsFields = sortExplorationResultsFields;
const getDefaultFieldsFromJobCaps = (fields, jobConfig, needsDestIndexFields) => {
  const fieldsObj = {
    selectedFields: [],
    docFields: []
  };
  if (fields.length === 0) {
    return fieldsObj;
  }

  // default is 'ml'
  const resultsField = jobConfig.dest.results_field;
  const allFields = [];
  let type;
  let predictedField;
  if ((0, _analytics_utils.isOutlierAnalysis)(jobConfig.analysis)) {
    if (!jobConfig.analysis.outlier_detection.compute_feature_influence) {
      // remove all feature influence fields
      fields = fields.filter(field => !field.name.includes(`${resultsField}.${_constants.FEATURE_INFLUENCE}`));
    } else {
      // remove flattened feature influence fields
      fields = fields.filter(field => !field.name.includes(`${resultsField}.${_constants.FEATURE_INFLUENCE}.`));
    }

    // Only need to add these fields if we didn't use dest data view to get the fields
    if (needsDestIndexFields === true) {
      allFields.push({
        id: `${resultsField}.${_constants.OUTLIER_SCORE}`,
        name: `${resultsField}.${_constants.OUTLIER_SCORE}`,
        type: _fieldTypes.KBN_FIELD_TYPES.NUMBER
      });
    }
  }
  if ((0, _analytics_utils.isClassificationAnalysis)(jobConfig.analysis) || (0, _analytics_utils.isRegressionAnalysis)(jobConfig.analysis)) {
    var _newJobCapsServiceAna;
    const dependentVariable = (0, _analytics_utils.getDependentVar)(jobConfig.analysis);
    type = (_newJobCapsServiceAna = _new_job_capabilities_service_analytics.newJobCapsServiceAnalytics.getFieldById(dependentVariable)) === null || _newJobCapsServiceAna === void 0 ? void 0 : _newJobCapsServiceAna.type;
    const predictionFieldName = (0, _analytics_utils.getPredictionFieldName)(jobConfig.analysis);
    const numTopFeatureImportanceValues = (0, _analytics.getNumTopFeatureImportanceValues)(jobConfig.analysis);
    const numTopClasses = (0, _analytics.getNumTopClasses)(jobConfig.analysis);
    const defaultPredictionField = `${dependentVariable}_prediction`;
    predictedField = `${resultsField}.${predictionFieldName ? predictionFieldName : defaultPredictionField}`;
    if ((numTopFeatureImportanceValues !== null && numTopFeatureImportanceValues !== void 0 ? numTopFeatureImportanceValues : 0) === 0) {
      // remove all feature importance fields
      fields = fields.filter(field => !field.name.includes(`${resultsField}.${_constants.FEATURE_IMPORTANCE}`));
    } else {
      // remove flattened feature importance fields
      fields = fields.filter(field => !field.name.includes(`${resultsField}.${_constants.FEATURE_IMPORTANCE}.`));
    }
    if ((numTopClasses !== null && numTopClasses !== void 0 ? numTopClasses : 0) === 0) {
      // remove all top classes fields
      fields = fields.filter(field => !field.name.includes(`${resultsField}.${_constants.TOP_CLASSES}`));
    } else {
      // remove flattened top classes fields
      fields = fields.filter(field => !field.name.includes(`${resultsField}.${_constants.TOP_CLASSES}.`));
    }

    // Only need to add these fields if we didn't use dest data view to get the fields
    if (needsDestIndexFields === true) {
      allFields.push({
        id: `${resultsField}.is_training`,
        name: `${resultsField}.is_training`,
        type: _fieldTypes.ES_FIELD_TYPES.BOOLEAN
      }, {
        id: predictedField,
        name: predictedField,
        type
      });
    }
  }
  allFields.push(...fields);
  allFields.sort(({
    name: a
  }, {
    name: b
  }) => sortExplorationResultsFields(a, b, jobConfig));
  let selectedFields = allFields.filter(field => field.name === predictedField || !field.name.includes('.keyword'));
  if (selectedFields.length > DEFAULT_REGRESSION_COLUMNS) {
    selectedFields = selectedFields.slice(0, DEFAULT_REGRESSION_COLUMNS);
  }
  return {
    selectedFields,
    docFields: allFields,
    depVarType: type
  };
};
exports.getDefaultFieldsFromJobCaps = getDefaultFieldsFromJobCaps;