"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ANALYSIS_ADVANCED_FIELDS = void 0;
Object.defineProperty(exports, "ANALYSIS_CONFIG_TYPE", {
  enumerable: true,
  get: function () {
    return _data_frame_analytics.ANALYSIS_CONFIG_TYPE;
  }
});
exports.defaultSearchQuery = exports.TRAINING_PERCENT_MIN = exports.TRAINING_PERCENT_MAX = exports.SEARCH_SIZE = exports.REGRESSION_STATS = exports.REFRESH_ANALYTICS_LIST_STATE = exports.OUTLIER_ANALYSIS_METHOD = exports.NUM_TOP_FEATURE_IMPORTANCE_VALUES_MIN = exports.INDEX_STATUS = exports.EMPTY_STAT = void 0;
Object.defineProperty(exports, "getAnalysisType", {
  enumerable: true,
  get: function () {
    return _analytics_utils.getAnalysisType;
  }
});
exports.getDefaultTrainingFilterQuery = void 0;
Object.defineProperty(exports, "getDependentVar", {
  enumerable: true,
  get: function () {
    return _analytics_utils.getDependentVar;
  }
});
exports.getEvalQueryBody = getEvalQueryBody;
exports.getNumTopFeatureImportanceValues = exports.getNumTopClasses = void 0;
Object.defineProperty(exports, "getPredictedFieldName", {
  enumerable: true,
  get: function () {
    return _analytics_utils.getPredictedFieldName;
  }
});
Object.defineProperty(exports, "getPredictionFieldName", {
  enumerable: true,
  get: function () {
    return _analytics_utils.getPredictionFieldName;
  }
});
exports.getTrainingPercent = void 0;
exports.getValuesFromResponse = getValuesFromResponse;
Object.defineProperty(exports, "isClassificationAnalysis", {
  enumerable: true,
  get: function () {
    return _analytics_utils.isClassificationAnalysis;
  }
});
exports.isClassificationEvaluateResponse = void 0;
Object.defineProperty(exports, "isOutlierAnalysis", {
  enumerable: true,
  get: function () {
    return _analytics_utils.isOutlierAnalysis;
  }
});
exports.isQueryStringQuery = void 0;
Object.defineProperty(exports, "isRegressionAnalysis", {
  enumerable: true,
  get: function () {
    return _analytics_utils.isRegressionAnalysis;
  }
});
exports.useRefreshAnalyticsList = exports.refreshAnalyticsList$ = exports.loadEvalData = exports.loadDocsCount = exports.isResultsSearchBoolQuery = exports.isRegressionEvaluateResponse = void 0;
var _react = require("react");
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _lodash = require("lodash");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _ml_api_service = require("../../services/ml_api_service");
var _analytics_utils = require("../../../../common/util/analytics_utils");
var _data_frame_analytics = require("../../../../common/constants/data_frame_analytics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ANALYSIS_ADVANCED_FIELDS;
exports.ANALYSIS_ADVANCED_FIELDS = ANALYSIS_ADVANCED_FIELDS;
(function (ANALYSIS_ADVANCED_FIELDS) {
  ANALYSIS_ADVANCED_FIELDS["ALPHA"] = "alpha";
  ANALYSIS_ADVANCED_FIELDS["ETA"] = "eta";
  ANALYSIS_ADVANCED_FIELDS["ETA_GROWTH_RATE_PER_TREE"] = "eta_growth_rate_per_tree";
  ANALYSIS_ADVANCED_FIELDS["DOWNSAMPLE_FACTOR"] = "downsample_factor";
  ANALYSIS_ADVANCED_FIELDS["FEATURE_BAG_FRACTION"] = "feature_bag_fraction";
  ANALYSIS_ADVANCED_FIELDS["FEATURE_INFLUENCE_THRESHOLD"] = "feature_influence_threshold";
  ANALYSIS_ADVANCED_FIELDS["GAMMA"] = "gamma";
  ANALYSIS_ADVANCED_FIELDS["LAMBDA"] = "lambda";
  ANALYSIS_ADVANCED_FIELDS["MAX_TREES"] = "max_trees";
  ANALYSIS_ADVANCED_FIELDS["MAX_OPTIMIZATION_ROUNDS_PER_HYPERPARAMETER"] = "max_optimization_rounds_per_hyperparameter";
  ANALYSIS_ADVANCED_FIELDS["METHOD"] = "method";
  ANALYSIS_ADVANCED_FIELDS["N_NEIGHBORS"] = "n_neighbors";
  ANALYSIS_ADVANCED_FIELDS["NUM_TOP_CLASSES"] = "num_top_classes";
  ANALYSIS_ADVANCED_FIELDS["NUM_TOP_FEATURE_IMPORTANCE_VALUES"] = "num_top_feature_importance_values";
  ANALYSIS_ADVANCED_FIELDS["OUTLIER_FRACTION"] = "outlier_fraction";
  ANALYSIS_ADVANCED_FIELDS["RANDOMIZE_SEED"] = "randomize_seed";
  ANALYSIS_ADVANCED_FIELDS["SOFT_TREE_DEPTH_LIMIT"] = "soft_tree_depth_limit";
  ANALYSIS_ADVANCED_FIELDS["SOFT_TREE_DEPTH_TOLERANCE"] = "soft_tree_depth_tolerance";
})(ANALYSIS_ADVANCED_FIELDS || (exports.ANALYSIS_ADVANCED_FIELDS = ANALYSIS_ADVANCED_FIELDS = {}));
let OUTLIER_ANALYSIS_METHOD;
exports.OUTLIER_ANALYSIS_METHOD = OUTLIER_ANALYSIS_METHOD;
(function (OUTLIER_ANALYSIS_METHOD) {
  OUTLIER_ANALYSIS_METHOD["LOF"] = "lof";
  OUTLIER_ANALYSIS_METHOD["LDOF"] = "ldof";
  OUTLIER_ANALYSIS_METHOD["DISTANCE_KTH_NN"] = "distance_kth_nn";
  OUTLIER_ANALYSIS_METHOD["DISTANCE_KNN"] = "distance_knn";
})(OUTLIER_ANALYSIS_METHOD || (exports.OUTLIER_ANALYSIS_METHOD = OUTLIER_ANALYSIS_METHOD = {}));
const SEARCH_SIZE = 1000;
exports.SEARCH_SIZE = SEARCH_SIZE;
const TRAINING_PERCENT_MIN = 1;
exports.TRAINING_PERCENT_MIN = TRAINING_PERCENT_MIN;
const TRAINING_PERCENT_MAX = 100;
exports.TRAINING_PERCENT_MAX = TRAINING_PERCENT_MAX;
const NUM_TOP_FEATURE_IMPORTANCE_VALUES_MIN = 0;
exports.NUM_TOP_FEATURE_IMPORTANCE_VALUES_MIN = NUM_TOP_FEATURE_IMPORTANCE_VALUES_MIN;
const defaultSearchQuery = {
  match_all: {}
};
exports.defaultSearchQuery = defaultSearchQuery;
const getDefaultTrainingFilterQuery = (resultsField, isTraining) => ({
  bool: {
    minimum_should_match: 1,
    should: [{
      match: {
        [`${resultsField}.is_training`]: isTraining
      }
    }]
  }
});
exports.getDefaultTrainingFilterQuery = getDefaultTrainingFilterQuery;
let INDEX_STATUS;
exports.INDEX_STATUS = INDEX_STATUS;
(function (INDEX_STATUS) {
  INDEX_STATUS[INDEX_STATUS["UNUSED"] = 0] = "UNUSED";
  INDEX_STATUS[INDEX_STATUS["LOADING"] = 1] = "LOADING";
  INDEX_STATUS[INDEX_STATUS["LOADED"] = 2] = "LOADED";
  INDEX_STATUS[INDEX_STATUS["ERROR"] = 3] = "ERROR";
})(INDEX_STATUS || (exports.INDEX_STATUS = INDEX_STATUS = {}));
const getTrainingPercent = analysis => {
  let trainingPercent;
  if ((0, _analytics_utils.isRegressionAnalysis)(analysis)) {
    trainingPercent = analysis.regression.training_percent;
  }
  if ((0, _analytics_utils.isClassificationAnalysis)(analysis)) {
    trainingPercent = analysis.classification.training_percent;
  }
  return trainingPercent;
};
exports.getTrainingPercent = getTrainingPercent;
const getNumTopClasses = analysis => {
  let numTopClasses;
  if ((0, _analytics_utils.isClassificationAnalysis)(analysis) && analysis.classification.num_top_classes !== undefined) {
    numTopClasses = analysis.classification.num_top_classes;
  }
  return numTopClasses;
};
exports.getNumTopClasses = getNumTopClasses;
const getNumTopFeatureImportanceValues = analysis => {
  let numTopFeatureImportanceValues;
  if ((0, _analytics_utils.isRegressionAnalysis)(analysis) && analysis.regression.num_top_feature_importance_values !== undefined) {
    numTopFeatureImportanceValues = analysis.regression.num_top_feature_importance_values;
  } else if ((0, _analytics_utils.isClassificationAnalysis)(analysis) && analysis.classification.num_top_feature_importance_values !== undefined) {
    numTopFeatureImportanceValues = analysis.classification.num_top_feature_importance_values;
  }
  return numTopFeatureImportanceValues;
};
exports.getNumTopFeatureImportanceValues = getNumTopFeatureImportanceValues;
const isResultsSearchBoolQuery = arg => {
  if (arg === undefined) return false;
  const keys = Object.keys(arg);
  return keys.length === 1 && keys[0] === 'bool';
};
exports.isResultsSearchBoolQuery = isResultsSearchBoolQuery;
const isQueryStringQuery = arg => {
  if (arg === undefined) return false;
  const keys = Object.keys(arg);
  return keys.length === 1 && keys[0] === 'query_string';
};
exports.isQueryStringQuery = isQueryStringQuery;
const isRegressionEvaluateResponse = arg => {
  var _arg$regression, _arg$regression2;
  const keys = Object.keys(arg);
  return keys.length === 1 && keys[0] === _data_frame_analytics.ANALYSIS_CONFIG_TYPE.REGRESSION && (arg === null || arg === void 0 ? void 0 : (_arg$regression = arg.regression) === null || _arg$regression === void 0 ? void 0 : _arg$regression.mse) !== undefined && (arg === null || arg === void 0 ? void 0 : (_arg$regression2 = arg.regression) === null || _arg$regression2 === void 0 ? void 0 : _arg$regression2.r_squared) !== undefined;
};
exports.isRegressionEvaluateResponse = isRegressionEvaluateResponse;
const isClassificationEvaluateResponse = arg => {
  var _arg$classification, _arg$classification2;
  const keys = Object.keys(arg);
  return keys.length === 1 && keys[0] === _data_frame_analytics.ANALYSIS_CONFIG_TYPE.CLASSIFICATION && ((arg === null || arg === void 0 ? void 0 : (_arg$classification = arg.classification) === null || _arg$classification === void 0 ? void 0 : _arg$classification.multiclass_confusion_matrix) !== undefined || (arg === null || arg === void 0 ? void 0 : (_arg$classification2 = arg.classification) === null || _arg$classification2 === void 0 ? void 0 : _arg$classification2.auc_roc) !== undefined);
};
exports.isClassificationEvaluateResponse = isClassificationEvaluateResponse;
let REFRESH_ANALYTICS_LIST_STATE;
exports.REFRESH_ANALYTICS_LIST_STATE = REFRESH_ANALYTICS_LIST_STATE;
(function (REFRESH_ANALYTICS_LIST_STATE) {
  REFRESH_ANALYTICS_LIST_STATE["ERROR"] = "error";
  REFRESH_ANALYTICS_LIST_STATE["IDLE"] = "idle";
  REFRESH_ANALYTICS_LIST_STATE["LOADING"] = "loading";
  REFRESH_ANALYTICS_LIST_STATE["REFRESH"] = "refresh";
})(REFRESH_ANALYTICS_LIST_STATE || (exports.REFRESH_ANALYTICS_LIST_STATE = REFRESH_ANALYTICS_LIST_STATE = {}));
const refreshAnalyticsList$ = new _rxjs.BehaviorSubject(REFRESH_ANALYTICS_LIST_STATE.IDLE);
exports.refreshAnalyticsList$ = refreshAnalyticsList$;
const useRefreshAnalyticsList = (callback = {}) => {
  (0, _react.useEffect)(() => {
    const distinct$ = refreshAnalyticsList$.pipe((0, _operators.distinctUntilChanged)());
    const subscriptions = [];
    if (typeof callback.onRefresh === 'function') {
      subscriptions.push(distinct$.pipe((0, _operators.filter)(state => state === REFRESH_ANALYTICS_LIST_STATE.REFRESH)).subscribe(() => {
        if (typeof callback.onRefresh === 'function') {
          callback.onRefresh();
        }
      }));
    }
    if (typeof callback.isLoading === 'function') {
      subscriptions.push(distinct$.subscribe(state => typeof callback.isLoading === 'function' && callback.isLoading(state === REFRESH_ANALYTICS_LIST_STATE.LOADING)));
    }
    return () => {
      subscriptions.map(sub => sub.unsubscribe());
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [callback.onRefresh]);
  return {
    refresh: () => {
      // A refresh is followed immediately by setting the state to loading
      // to trigger data fetching and loading indicators in one go.
      refreshAnalyticsList$.next(REFRESH_ANALYTICS_LIST_STATE.REFRESH);
      refreshAnalyticsList$.next(REFRESH_ANALYTICS_LIST_STATE.LOADING);
    }
  };
};
exports.useRefreshAnalyticsList = useRefreshAnalyticsList;
const DEFAULT_SIG_FIGS = 3;
const EMPTY_STAT = '--';
exports.EMPTY_STAT = EMPTY_STAT;
function getValuesFromResponse(response) {
  const results = {
    mse: EMPTY_STAT,
    msle: EMPTY_STAT,
    huber: EMPTY_STAT,
    r_squared: EMPTY_STAT
  };
  if (response !== null && response !== void 0 && response.regression) {
    for (const statType in response.regression) {
      if (response.regression.hasOwnProperty(statType)) {
        var _response$regression;
        let currentStatValue = (_response$regression = response.regression[statType]) === null || _response$regression === void 0 ? void 0 : _response$regression.value;
        if (currentStatValue && Number.isFinite(currentStatValue)) {
          currentStatValue = Number(currentStatValue.toPrecision(DEFAULT_SIG_FIGS));
        }
        results[statType] = currentStatValue;
      }
    }
  }
  return results;
}
function getEvalQueryBody({
  resultsField,
  isTraining,
  searchQuery,
  ignoreDefaultQuery
}) {
  let query;
  const trainingQuery = {
    term: {
      [`${resultsField}.is_training`]: {
        value: isTraining
      }
    }
  };
  const searchQueryClone = (0, _lodash.cloneDeep)(searchQuery);
  if (isResultsSearchBoolQuery(searchQueryClone)) {
    if (searchQueryClone.bool.must === undefined) {
      searchQueryClone.bool.must = [];
    }
    if (isTraining !== undefined) {
      searchQueryClone.bool.must.push(trainingQuery);
    }
    query = searchQueryClone;
  } else if (isQueryStringQuery(searchQueryClone)) {
    query = {
      bool: {
        must: [searchQueryClone]
      }
    };
    if (isTraining !== undefined) {
      query.bool.must.push(trainingQuery);
    }
  } else {
    // Not a bool or string query so we need to create it so can add the trainingQuery
    query = {
      bool: {
        must: isTraining !== undefined ? [trainingQuery] : []
      }
    };
  }
  return query;
}
let REGRESSION_STATS;
exports.REGRESSION_STATS = REGRESSION_STATS;
(function (REGRESSION_STATS) {
  REGRESSION_STATS["MSE"] = "mse";
  REGRESSION_STATS["MSLE"] = "msle";
  REGRESSION_STATS["R_SQUARED"] = "rSquared";
  REGRESSION_STATS["HUBER"] = "huber";
})(REGRESSION_STATS || (exports.REGRESSION_STATS = REGRESSION_STATS = {}));
const loadEvalData = async ({
  isTraining,
  index,
  dependentVariable,
  resultsField,
  predictionFieldName,
  searchQuery,
  ignoreDefaultQuery,
  jobType,
  requiresKeyword,
  rocCurveClassName,
  includeMulticlassConfusionMatrix = true
}) => {
  const results = {
    success: false,
    eval: null,
    error: null
  };
  const defaultPredictionField = `${dependentVariable}_prediction`;
  let predictedField = `${resultsField}.${predictionFieldName ? predictionFieldName : defaultPredictionField}`;
  if (jobType === _data_frame_analytics.ANALYSIS_CONFIG_TYPE.CLASSIFICATION && requiresKeyword === true) {
    predictedField = `${predictedField}.keyword`;
  }
  const query = getEvalQueryBody({
    resultsField,
    isTraining,
    searchQuery,
    ignoreDefaultQuery
  });
  const metrics = {
    classification: {
      accuracy: {},
      recall: {},
      ...(includeMulticlassConfusionMatrix ? {
        multiclass_confusion_matrix: {}
      } : {}),
      ...(rocCurveClassName !== undefined ? {
        auc_roc: {
          include_curve: true,
          class_name: rocCurveClassName
        }
      } : {})
    },
    regression: {
      r_squared: {},
      mse: {},
      msle: {},
      huber: {}
    }
  };
  const config = {
    index,
    query,
    evaluation: {
      [jobType]: {
        actual_field: dependentVariable,
        predicted_field: predictedField,
        ...(jobType === _data_frame_analytics.ANALYSIS_CONFIG_TYPE.CLASSIFICATION ? {
          top_classes_field: `${resultsField}.top_classes`
        } : {}),
        metrics: metrics[jobType]
      }
    }
  };
  try {
    const evalResult = await _ml_api_service.ml.dataFrameAnalytics.evaluateDataFrameAnalytics(config);
    results.success = true;
    results.eval = evalResult;
    return results;
  } catch (e) {
    results.error = (0, _mlErrorUtils.extractErrorMessage)(e);
    return results;
  }
};
exports.loadEvalData = loadEvalData;
const loadDocsCount = async ({
  ignoreDefaultQuery = true,
  isTraining,
  searchQuery,
  resultsField,
  destIndex
}) => {
  const query = getEvalQueryBody({
    resultsField,
    isTraining,
    ignoreDefaultQuery,
    searchQuery
  });
  try {
    const body = {
      track_total_hits: true,
      query
    };
    const resp = await _ml_api_service.ml.esSearch({
      index: destIndex,
      size: 0,
      body
    });
    const docsCount = resp.hits.total && resp.hits.total.value;
    return {
      docsCount,
      success: docsCount !== undefined
    };
  } catch (e) {
    return {
      docsCount: null,
      success: false
    };
  }
};
exports.loadDocsCount = loadDocsCount;