"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFieldFormatter = useFieldFormatter;
var _common = require("@kbn/field-formats-plugin/common");
var _kibana_context = require("./kibana_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Set of reasonable defaults for formatters for the ML app.
 */
const defaultParam = {
  [_common.FIELD_FORMAT_IDS.DURATION]: {
    inputFormat: 'milliseconds',
    outputFormat: 'humanizePrecise'
  }
};
function useFieldFormatter(fieldType) {
  const {
    services: {
      fieldFormats
    }
  } = (0, _kibana_context.useMlKibana)();
  const fieldFormatter = fieldFormats.deserialize({
    id: fieldType,
    params: defaultParam[fieldType]
  });
  return fieldFormatter.convert.bind(fieldFormatter);
}