"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditConditionLink = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _detector_rule = require("../../../../../common/constants/detector_rule");
var _format_value = require("../../../formatters/format_value");
var _utils = require("../utils");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * React component for quick edit of the numeric condition part of a rule,
 * containing a number field input for editing the condition value.
 */

class EditConditionLink extends _react.Component {
  constructor(props) {
    super(props);

    // Initialize value to anomaly value, if it exists.
    // Do rounding at this initialization stage. Then if the user
    // really wants to define to higher precision they can.
    // Format based on magnitude of value at this stage, rather than using the
    // Kibana field formatter (if set) which would add complexity converting
    // the entered value to / from e.g. bytes.
    (0, _defineProperty2.default)(this, "onChangeValue", event => {
      const enteredValue = event.target.value;
      this.setState({
        value: enteredValue !== '' ? +enteredValue : ''
      });
    });
    (0, _defineProperty2.default)(this, "onUpdateClick", () => {
      const {
        conditionIndex,
        updateConditionValue
      } = this.props;
      updateConditionValue(conditionIndex, this.state.value);
    });
    let value = '';
    const anomaly = this.props.anomaly;
    const anomalyValue = (0, _utils.getAppliesToValueFromAnomaly)(anomaly, props.appliesTo);
    if (anomalyValue !== undefined) {
      value = +(0, _format_value.formatValue)(anomalyValue, anomaly.source.function);
    }
    this.state = {
      value
    };
  }
  render() {
    const value = this.state.value;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: 's'
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.ruleEditor.editConditionLink.updateRuleConditionFromText",
      defaultMessage: "Update rule condition from {conditionValue} to",
      values: {
        conditionValue: this.props.conditionValue
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      className: "condition-edit-value-field"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      placeholder: _i18n.i18n.translate('xpack.ml.ruleEditor.editConditionLink.enterValuePlaceholder', {
        defaultMessage: 'Enter value'
      }),
      compressed: true,
      value: value,
      onChange: this.onChangeValue,
      "aria-label": _i18n.i18n.translate('xpack.ml.ruleEditor.editConditionLink.enterNumericValueForConditionAriaLabel', {
        defaultMessage: 'Enter numeric value for condition'
      })
    })), value !== '' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      size: "s",
      onClick: () => this.onUpdateClick()
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.ruleEditor.editConditionLink.updateLinkText",
      defaultMessage: "Update"
    }))));
  }
}
exports.EditConditionLink = EditConditionLink;
(0, _defineProperty2.default)(EditConditionLink, "propTypes", {
  conditionIndex: _propTypes.default.number.isRequired,
  conditionValue: _propTypes.default.number.isRequired,
  appliesTo: _propTypes.default.oneOf([_detector_rule.APPLIES_TO.ACTUAL, _detector_rule.APPLIES_TO.TYPICAL, _detector_rule.APPLIES_TO.DIFF_FROM_TYPICAL]),
  anomaly: _propTypes.default.object.isRequired,
  updateConditionValue: _propTypes.default.func.isRequired
});