"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleEditorFlyout = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _detector_description_list = require("./components/detector_description_list");
var _actions_section = require("./actions_section");
var _check_capabilities = require("../../capabilities/check_capabilities");
var _conditions_section = require("./conditions_section");
var _scope_section = require("./scope_section");
var _select_rule_action = require("./select_rule_action");
var _utils = require("./utils");
var _detector_rule = require("../../../../common/constants/detector_rule");
var _job_utils = require("../../../../common/util/job_utils");
var _public = require("@kbn/kibana-react-plugin/public");
var _job_service = require("../../services/job_service");
var _ml_api_service = require("../../services/ml_api_service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Flyout component for viewing and editing job detector rules.
 */

class RuleEditorFlyoutUI extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "showFlyout", anomaly => {
      let ruleIndex = -1;
      const job = _job_service.mlJobService.getJob(anomaly.jobId);
      if (job === undefined) {
        // No details found for this job, display an error and
        // don't open the Flyout as no edits can be made without the job.
        const {
          toasts
        } = this.props.kibana.services.notifications;
        toasts.addDanger(_i18n.i18n.translate('xpack.ml.ruleEditor.ruleEditorFlyout.unableToConfigureRulesNotificationMesssage', {
          defaultMessage: 'Unable to configure job rules as an error occurred obtaining details for job ID {jobId}',
          values: {
            jobId: anomaly.jobId
          }
        }));
        this.setState({
          job,
          isFlyoutVisible: false
        });
        return;
      }
      this.partitioningFieldNames = (0, _job_utils.getPartitioningFieldNames)(job, anomaly.detectorIndex);

      // Check if any rules are configured for this detector.
      const detectorIndex = anomaly.detectorIndex;
      const detector = job.analysis_config.detectors[detectorIndex];
      if (detector.custom_rules === undefined) {
        ruleIndex = 0;
      }
      let isConditionsEnabled = false;
      if (ruleIndex === 0) {
        // Configuring the first rule for a detector.
        isConditionsEnabled = this.partitioningFieldNames.length === 0;
      }
      this.setState({
        anomaly,
        job,
        ruleIndex,
        isConditionsEnabled,
        isScopeEnabled: false,
        isFlyoutVisible: true
      });
      if (this.partitioningFieldNames.length > 0 && this.canGetFilters) {
        // Load the current list of filters. These are used for configuring rule scope.
        _ml_api_service.ml.filters.filters().then(filters => {
          const filterListIds = filters.map(filter => filter.filter_id);
          this.setState({
            filterListIds
          });
        }).catch(resp => {
          console.log('Error loading list of filters:', resp);
          const {
            toasts
          } = this.props.kibana.services.notifications;
          toasts.addDanger(_i18n.i18n.translate('xpack.ml.ruleEditor.ruleEditorFlyout.errorWithLoadingFilterListsNotificationMesssage', {
            defaultMessage: 'Error loading the filter lists used in the job rule scope'
          }));
        });
      }
    });
    (0, _defineProperty2.default)(this, "closeFlyout", () => {
      this.setState({
        isFlyoutVisible: false
      });
    });
    (0, _defineProperty2.default)(this, "setEditRuleIndex", ruleIndex => {
      const detectorIndex = this.state.anomaly.detectorIndex;
      const detector = this.state.job.analysis_config.detectors[detectorIndex];
      const rules = detector.custom_rules;
      const rule = rules === undefined || ruleIndex >= rules.length ? (0, _utils.getNewRuleDefaults)() : rules[ruleIndex];
      const isConditionsEnabled = this.partitioningFieldNames.length === 0 || rule.conditions !== undefined && rule.conditions.length > 0;
      const isScopeEnabled = rule.scope !== undefined && Object.keys(rule.scope).length > 0;
      if (isScopeEnabled === true) {
        // Add 'enabled:true' to mark them as selected in the UI.
        Object.keys(rule.scope).forEach(field => {
          rule.scope[field].enabled = true;
        });
      }
      this.setState({
        ruleIndex,
        rule,
        isConditionsEnabled,
        isScopeEnabled
      });
    });
    (0, _defineProperty2.default)(this, "onSkipResultChange", e => {
      const checked = e.target.checked;
      this.setState(prevState => {
        const actions = [...prevState.rule.actions];
        const idx = actions.indexOf(_detector_rule.ACTION.SKIP_RESULT);
        if (idx === -1 && checked) {
          actions.push(_detector_rule.ACTION.SKIP_RESULT);
        } else if (idx > -1 && !checked) {
          actions.splice(idx, 1);
        }
        return {
          rule: {
            ...prevState.rule,
            actions
          }
        };
      });
    });
    (0, _defineProperty2.default)(this, "onSkipModelUpdateChange", e => {
      const checked = e.target.checked;
      this.setState(prevState => {
        const actions = [...prevState.rule.actions];
        const idx = actions.indexOf(_detector_rule.ACTION.SKIP_MODEL_UPDATE);
        if (idx === -1 && checked) {
          actions.push(_detector_rule.ACTION.SKIP_MODEL_UPDATE);
        } else if (idx > -1 && !checked) {
          actions.splice(idx, 1);
        }
        return {
          rule: {
            ...prevState.rule,
            actions
          }
        };
      });
    });
    (0, _defineProperty2.default)(this, "onConditionsEnabledChange", e => {
      const isConditionsEnabled = e.target.checked;
      this.setState(prevState => {
        let conditions;
        if (isConditionsEnabled === false) {
          // Clear any conditions that have been added.
          conditions = [];
        } else {
          // Add a default new condition.
          conditions = [(0, _utils.getNewConditionDefaults)()];
        }
        return {
          rule: {
            ...prevState.rule,
            conditions
          },
          isConditionsEnabled
        };
      });
    });
    (0, _defineProperty2.default)(this, "addCondition", () => {
      this.setState(prevState => {
        const conditions = [...prevState.rule.conditions];
        conditions.push((0, _utils.getNewConditionDefaults)());
        return {
          rule: {
            ...prevState.rule,
            conditions
          }
        };
      });
    });
    (0, _defineProperty2.default)(this, "updateCondition", (index, appliesTo, operator, value) => {
      this.setState(prevState => {
        const conditions = [...prevState.rule.conditions];
        if (index < conditions.length) {
          conditions[index] = {
            applies_to: appliesTo,
            operator,
            value
          };
        }
        return {
          rule: {
            ...prevState.rule,
            conditions
          }
        };
      });
    });
    (0, _defineProperty2.default)(this, "deleteCondition", index => {
      this.setState(prevState => {
        const conditions = [...prevState.rule.conditions];
        if (index < conditions.length) {
          conditions.splice(index, 1);
        }
        return {
          rule: {
            ...prevState.rule,
            conditions
          }
        };
      });
    });
    (0, _defineProperty2.default)(this, "onScopeEnabledChange", e => {
      const isScopeEnabled = e.target.checked;
      this.setState(prevState => {
        const rule = {
          ...prevState.rule
        };
        if (isScopeEnabled === false) {
          // Clear scope property.
          delete rule.scope;
        }
        return {
          rule,
          isScopeEnabled
        };
      });
    });
    (0, _defineProperty2.default)(this, "updateScope", (fieldName, filterId, filterType, enabled) => {
      this.setState(prevState => {
        let scope = {
          ...prevState.rule.scope
        };
        if (scope === undefined) {
          scope = {};
        }
        scope[fieldName] = {
          filter_id: filterId,
          filter_type: filterType,
          enabled
        };
        return {
          rule: {
            ...prevState.rule,
            scope
          }
        };
      });
    });
    (0, _defineProperty2.default)(this, "saveEdit", () => {
      const {
        rule,
        ruleIndex
      } = this.state;
      this.updateRuleAtIndex(ruleIndex, rule);
    });
    (0, _defineProperty2.default)(this, "updateRuleAtIndex", (ruleIndex, editedRule) => {
      const {
        toasts
      } = this.props.kibana.services.notifications;
      const {
        job,
        anomaly
      } = this.state;
      const jobId = job.job_id;
      const detectorIndex = anomaly.detectorIndex;
      (0, _utils.saveJobRule)(job, detectorIndex, ruleIndex, editedRule).then(resp => {
        if (resp.success) {
          toasts.add({
            title: _i18n.i18n.translate('xpack.ml.ruleEditor.ruleEditorFlyout.changesToJobDetectorRulesSavedNotificationMessageTitle', {
              defaultMessage: 'Changes to {jobId} detector rules saved',
              values: {
                jobId
              }
            }),
            color: 'success',
            iconType: 'check',
            text: _i18n.i18n.translate('xpack.ml.ruleEditor.ruleEditorFlyout.changesToJobDetectorRulesSavedNotificationMessageDescription', {
              defaultMessage: 'Note that changes will take effect for new results only.'
            })
          });
          this.closeFlyout();
        } else {
          toasts.addDanger(_i18n.i18n.translate('xpack.ml.ruleEditor.ruleEditorFlyout.errorWithSavingChangesToJobDetectorRulesNotificationMessage', {
            defaultMessage: 'Error saving changes to {jobId} detector rules',
            values: {
              jobId
            }
          }));
        }
      }).catch(error => {
        console.error(error);
        toasts.addDanger(_i18n.i18n.translate('xpack.ml.ruleEditor.ruleEditorFlyout.errorWithSavingChangesToJobDetectorRulesNotificationMessage', {
          defaultMessage: 'Error saving changes to {jobId} detector rules',
          values: {
            jobId
          }
        }));
      });
    });
    (0, _defineProperty2.default)(this, "deleteRuleAtIndex", index => {
      const {
        toasts
      } = this.props.kibana.services.notifications;
      const {
        job,
        anomaly
      } = this.state;
      const jobId = job.job_id;
      const detectorIndex = anomaly.detectorIndex;
      (0, _utils.deleteJobRule)(job, detectorIndex, index).then(resp => {
        if (resp.success) {
          toasts.addSuccess(_i18n.i18n.translate('xpack.ml.ruleEditor.ruleEditorFlyout.ruleDeletedFromJobDetectorNotificationMessage', {
            defaultMessage: 'Rule deleted from {jobId} detector',
            values: {
              jobId
            }
          }));
          const updatedJob = _job_service.mlJobService.getJob(anomaly.jobId);
          const updatedDetector = updatedJob.analysis_config.detectors[detectorIndex];
          const updatedRules = updatedDetector.custom_rules;
          if (!updatedRules) {
            this.closeFlyout();
          } else {
            this.setState({
              job: {
                ...updatedJob
              }
            });
          }
        } else {
          toasts.addDanger(_i18n.i18n.translate('xpack.ml.ruleEditor.ruleEditorFlyout.errorWithDeletingRuleFromJobDetectorNotificationMessage', {
            defaultMessage: 'Error deleting rule from {jobId} detector',
            values: {
              jobId
            }
          }));
        }
      }).catch(error => {
        console.error(error);
        let errorMessage = _i18n.i18n.translate('xpack.ml.ruleEditor.ruleEditorFlyout.errorWithDeletingRuleFromJobDetectorNotificationMessage', {
          defaultMessage: 'Error deleting rule from {jobId} detector',
          values: {
            jobId
          }
        });
        if (error.error) {
          errorMessage += ` : ${(0, _mlErrorUtils.extractErrorMessage)(error.error)}`;
        }
        toasts.addDanger(errorMessage);
      });
    });
    (0, _defineProperty2.default)(this, "addItemToFilterList", (item, filterId, closeFlyoutOnAdd) => {
      const {
        toasts
      } = this.props.kibana.services.notifications;
      (0, _utils.addItemToFilter)(item, filterId).then(() => {
        if (closeFlyoutOnAdd === true) {
          toasts.add({
            title: _i18n.i18n.translate('xpack.ml.ruleEditor.ruleEditorFlyout.addedItemToFilterListNotificationMessageTitle', {
              defaultMessage: 'Added {item} to {filterId}',
              values: {
                item,
                filterId
              }
            }),
            color: 'success',
            iconType: 'check',
            text: _i18n.i18n.translate('xpack.ml.ruleEditor.ruleEditorFlyout.addedItemToFilterListNotificationMessageDescription', {
              defaultMessage: 'Note that changes will take effect for new results only.'
            })
          });
          this.closeFlyout();
        }
      }).catch(error => {
        console.log(`Error adding ${item} to filter ${filterId}:`, error);
        toasts.addDanger(_i18n.i18n.translate('xpack.ml.ruleEditor.ruleEditorFlyout.errorWithAddingItemToFilterListNotificationMessage', {
          defaultMessage: 'An error occurred adding {item} to filter {filterId}',
          values: {
            item,
            filterId
          }
        }));
      });
    });
    this.state = {
      anomaly: {},
      job: {},
      ruleIndex: -1,
      rule: (0, _utils.getNewRuleDefaults)(),
      skipModelUpdate: false,
      isConditionsEnabled: false,
      isScopeEnabled: false,
      filterListIds: [],
      isFlyoutVisible: false
    };
    this.partitioningFieldNames = [];
    this.canGetFilters = (0, _check_capabilities.checkPermission)('canGetFilters');
  }
  componentDidMount() {
    if (typeof this.props.setShowFunction === 'function') {
      this.props.setShowFunction(this.showFlyout);
    }
  }
  componentWillUnmount() {
    if (typeof this.props.unsetShowFunction === 'function') {
      this.props.unsetShowFunction();
    }
  }
  render() {
    const docsUrl = this.props.kibana.services.docLinks.links.ml.customRules;
    const {
      isFlyoutVisible,
      job,
      anomaly,
      ruleIndex,
      rule,
      filterListIds,
      isConditionsEnabled,
      isScopeEnabled
    } = this.state;
    if (isFlyoutVisible === false) {
      return null;
    }
    let flyout;
    if (ruleIndex === -1) {
      flyout = /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
        className: "ml-rule-editor-flyout",
        onClose: this.closeFlyout,
        "aria-labelledby": "flyoutTitle"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
        hasBorder: true
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "m"
      }, /*#__PURE__*/_react.default.createElement("h1", {
        id: "flyoutTitle"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.ruleEditorFlyout.editRulesTitle",
        defaultMessage: "Edit job rules"
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_select_rule_action.SelectRuleAction, {
        job: job,
        anomaly: anomaly,
        setEditRuleIndex: this.setEditRuleIndex,
        updateRuleAtIndex: this.updateRuleAtIndex,
        deleteRuleAtIndex: this.deleteRuleAtIndex,
        addItemToFilterList: this.addItemToFilterList
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "spaceBetween"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        iconType: "cross",
        onClick: this.closeFlyout,
        flush: "left"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.ruleEditorFlyout.closeButtonLabel",
        defaultMessage: "Close"
      }))))));
    } else {
      const detectorIndex = anomaly.detectorIndex;
      const detector = job.analysis_config.detectors[detectorIndex];
      const rules = detector.custom_rules;
      const isCreate = rules === undefined || ruleIndex >= rules.length;
      const hasPartitioningFields = this.partitioningFieldNames && this.partitioningFieldNames.length > 0;
      const conditionSupported = _detector_rule.CONDITIONS_NOT_SUPPORTED_FUNCTIONS.indexOf(anomaly.source.function) === -1;
      const conditionsText = _i18n.i18n.translate('xpack.ml.ruleEditor.ruleEditorFlyout.conditionsDescription', {
        defaultMessage: 'Add numeric conditions for when the job rule applies. Multiple conditions are combined using AND.'
      });
      flyout = /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
        className: "ml-rule-editor-flyout",
        onClose: this.closeFlyout,
        "aria-labelledby": "flyoutTitle"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
        hasBorder: true
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "m"
      }, /*#__PURE__*/_react.default.createElement("h1", {
        id: "flyoutTitle"
      }, isCreate === true ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.ruleEditorFlyout.createRuleTitle",
        defaultMessage: "Create job rule"
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.ruleEditorFlyout.editRuleTitle",
        defaultMessage: "Edit job rule"
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_detector_description_list.DetectorDescriptionList, {
        job: job,
        detector: detector,
        anomaly: anomaly
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.ruleEditorFlyout.rulesDescription",
        defaultMessage: "Job rules instruct anomaly detectors to change their behavior based on domain-specific knowledge that you provide. When you create a job rule, you can specify conditions, scope, and actions. When the conditions of a job rule are satisfied, its actions are triggered. {learnMoreLink}",
        values: {
          learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: docsUrl,
            target: "_blank"
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.ml.ruleEditor.ruleEditorFlyout.rulesDescription.learnMoreLinkText",
            defaultMessage: "Learn more"
          }))
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.ruleEditorFlyout.actionTitle",
        defaultMessage: "Action"
      }))), /*#__PURE__*/_react.default.createElement(_actions_section.ActionsSection, {
        actions: rule.actions,
        onSkipResultChange: this.onSkipResultChange,
        onSkipModelUpdateChange: this.onSkipModelUpdateChange
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xl"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.ruleEditorFlyout.conditionsTitle",
        defaultMessage: "Conditions"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), conditionSupported === true ? /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
        id: "enable_conditions_checkbox",
        className: "scope-enable-checkbox",
        label: conditionsText,
        checked: isConditionsEnabled,
        onChange: this.onConditionsEnabledChange,
        disabled: !conditionSupported || !hasPartitioningFields
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.ruleEditor.ruleEditorFlyout.conditionsNotSupportedTitle",
          defaultMessage: "Conditions are not supported for detectors using the {functionName} function",
          values: {
            functionName: anomaly.source.function
          }
        }),
        iconType: "iInCircle"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_conditions_section.ConditionsSection, {
        isEnabled: isConditionsEnabled,
        conditions: rule.conditions,
        addCondition: this.addCondition,
        updateCondition: this.updateCondition,
        deleteCondition: this.deleteCondition
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xl"
      }), /*#__PURE__*/_react.default.createElement(_scope_section.ScopeSection, {
        isEnabled: isScopeEnabled,
        onEnabledChange: this.onScopeEnabledChange,
        partitioningFieldNames: this.partitioningFieldNames,
        filterListIds: filterListIds,
        scope: rule.scope,
        updateScope: this.updateScope
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.ruleEditor.ruleEditorFlyout.rerunJobTitle",
          defaultMessage: "Rerun job"
        }),
        color: "warning",
        iconType: "help"
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.ruleEditorFlyout.whenChangesTakeEffectDescription",
        defaultMessage: "Changes to job rules take effect for new results only."
      })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.ruleEditorFlyout.howToApplyChangesToExistingResultsDescription",
        defaultMessage: "To apply these changes to existing results you must clone and rerun the job. Note rerunning the job may take some time and should only be done once you have completed all your changes to the rules for this job."
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "spaceBetween"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        iconType: "cross",
        onClick: this.closeFlyout,
        flush: "left"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.ruleEditorFlyout.closeButtonLabel",
        defaultMessage: "Close"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: this.saveEdit,
        isDisabled: !(0, _utils.isValidRule)(rule),
        fill: true
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.ruleEditorFlyout.saveButtonLabel",
        defaultMessage: "Save"
      }))))));
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, flyout);
  }
}
(0, _defineProperty2.default)(RuleEditorFlyoutUI, "propTypes", {
  setShowFunction: _propTypes.default.func.isRequired,
  unsetShowFunction: _propTypes.default.func.isRequired
});
const RuleEditorFlyout = (0, _public.withKibana)(RuleEditorFlyoutUI);
exports.RuleEditorFlyout = RuleEditorFlyout;