"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetectorDescriptionList = DetectorDescriptionList;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _format_value = require("../../../../formatters/format_value");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * React component for listing pairs of information about the detector for which
 * rules are being edited.
 */

function DetectorDescriptionList({
  job,
  detector,
  anomaly
}) {
  const listItems = [{
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.ruleEditor.detectorDescriptionList.jobIdTitle",
      defaultMessage: "Job ID"
    }),
    description: job.job_id
  }, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.ruleEditor.detectorDescriptionList.detectorTitle",
      defaultMessage: "Detector"
    }),
    description: detector.detector_description
  }];
  if (anomaly.actual !== undefined) {
    // Format based on magnitude of value at this stage, rather than using the
    // Kibana field formatter (if set) which would add complexity converting
    // the entered value to / from e.g. bytes.
    const actual = (0, _format_value.formatValue)(anomaly.actual, anomaly.source.function);
    const typical = (0, _format_value.formatValue)(anomaly.typical, anomaly.source.function);
    listItems.push({
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.detectorDescriptionList.selectedAnomalyTitle",
        defaultMessage: "Selected anomaly"
      }),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.detectorDescriptionList.selectedAnomalyDescription",
        defaultMessage: "actual {actual}, typical {typical}",
        values: {
          actual,
          typical
        }
      })
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    className: "rule-detector-description-list",
    type: "column",
    listItems: listItems
  });
}
DetectorDescriptionList.propTypes = {
  job: _propTypes.default.object.isRequired,
  detector: _propTypes.default.object.isRequired,
  anomaly: _propTypes.default.object.isRequired
};