"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlPageHeaderRenderer = exports.MlPageHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactReversePortal = require("react-reverse-portal");
var _eui = require("@elastic/eui");
var _ml_page = require("../ml_page/ml_page");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Component for setting the page header content.
 */
const MlPageHeader = ({
  children
}) => {
  const {
    headerPortal,
    setIsHeaderMounted
  } = (0, _react.useContext)(_ml_page.MlPageControlsContext);
  (0, _react.useEffect)(() => {
    setIsHeaderMounted(true);
    return () => {
      setIsHeaderMounted(false);
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: headerPortal
  }, children);
};

/**
 * Renders content of the {@link MlPageHeader}
 */
exports.MlPageHeader = MlPageHeader;
const MlPageHeaderRenderer = () => {
  const {
    headerPortal,
    isHeaderMounted
  } = (0, _react.useContext)(_ml_page.MlPageControlsContext);
  return isHeaderMounted ? /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
    node: headerPortal
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingContent, {
    lines: 1
  });
};
exports.MlPageHeaderRenderer = MlPageHeaderRenderer;