"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MessageCallOut = MessageCallOut;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _message_levels = require("../../../../common/constants/message_levels");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Provides a wrapper around EuiCallOut for the display of error messages,
 * setting the icon and color according to a supplied MESSAGE_LEVEL.
 */

function getCallOutAttributes(message, status) {
  switch (status) {
    case _message_levels.MESSAGE_LEVEL.ERROR:
      return {
        title: message,
        iconType: 'cross',
        color: 'danger'
      };
    case _message_levels.MESSAGE_LEVEL.WARNING:
      return {
        title: message,
        iconType: 'warning',
        color: 'warning'
      };
    case _message_levels.MESSAGE_LEVEL.SUCCESS:
      return {
        title: message,
        iconType: 'check',
        color: 'success'
      };
    case _message_levels.MESSAGE_LEVEL.INFO:
      return {
        title: message,
        iconType: 'iInCircle',
        color: 'primary'
      };
  }
}
function MessageCallOut({
  message,
  status,
  ...rest
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, (0, _extends2.default)({
    size: "s"
  }, getCallOutAttributes(message, status), rest));
}
MessageCallOut.propTypes = {
  message: _propTypes.default.string,
  status: _propTypes.default.oneOf([_message_levels.MESSAGE_LEVEL.ERROR, _message_levels.MESSAGE_LEVEL.WARNING, _message_levels.MESSAGE_LEVEL.SUCCESS, _message_levels.MESSAGE_LEVEL.INFO])
};