"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkCard = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Component for rendering a card which links to the Create Job page, displaying an
// icon, card title, description and link.
const LinkCard = ({
  icon,
  iconAreaLabel,
  title,
  description,
  onClick,
  href,
  isDisabled,
  'data-test-subj': dataTestSubj
}) => {
  const linkHrefAndOnClickProps = {
    ...(href ? {
      href
    } : {}),
    ...(onClick ? {
      onClick
    } : {})
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    style: {
      cursor: isDisabled ? 'not-allowed' : undefined
    },
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
    style: {
      display: 'block',
      pointerEvents: isDisabled ? 'none' : undefined,
      background: 'transparent',
      outline: 'none'
    },
    "data-test-subj": dataTestSubj,
    color: "subdued"
  }, linkHrefAndOnClickProps), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    responsive: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      paddingTop: '8px'
    }
  }, typeof icon === 'string' ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "xl",
    type: icon,
    "aria-label": iconAreaLabel
  }) : icon), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, description))))));
};
exports.LinkCard = LinkCard;