"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewJobAwaitingNodeWarning = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _ml_nodes_check = require("../../ml_nodes_check");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NewJobAwaitingNodeWarning = () => {
  if ((0, _ml_nodes_check.lazyMlNodesAvailable)() === false) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsAwaitingNodeWarning.title",
      defaultMessage: "Awaiting machine learning node"
    }),
    color: "primary",
    iconType: "iInCircle"
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJobAwaitingNodeWarning.noMLNodesAvailableDescription",
    defaultMessage: "There are currently no nodes that can run the job, therefore it will remain in OPENING state until an appropriate node becomes available."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.NewJobAwaitingNodeWarning = NewJobAwaitingNodeWarning;