"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobSpacesSyncFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _kibana = require("../../contexts/kibana");
var _sync_list = require("./sync_list");
var _toast_notification_service = require("../../services/toast_notification_service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JobSpacesSyncFlyout = ({
  onClose
}) => {
  const {
    displayErrorToast,
    displaySuccessToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const [loading, setLoading] = (0, _react.useState)(false);
  const [canSync, setCanSync] = (0, _react.useState)(false);
  const [syncResp, setSyncResp] = (0, _react.useState)(null);
  const {
    savedObjects: {
      syncSavedObjects
    }
  } = (0, _kibana.useMlApiContext)();
  async function loadSyncList(simulate = true) {
    setLoading(true);
    try {
      const resp = await syncSavedObjects(simulate);
      setSyncResp(resp);
      const count = Object.values(resp).reduce((acc, cur) => acc + Object.keys(cur).length, 0);
      setCanSync(count > 0);
      setLoading(false);
      return resp;
    } catch (error) {
      // this shouldn't be hit as errors are returned per-sync task
      // as part of the response
      displayErrorToast(error);
      setLoading(false);
    }
    return null;
  }
  (0, _react.useEffect)(() => {
    loadSyncList();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  async function sync() {
    if (canSync) {
      // perform the sync
      const resp = await loadSyncList(false);
      // check simulate the sync again to check that all
      // items have been synchronized.
      await loadSyncList(true);
      if (resp === null) {
        return;
      }
      const {
        successCount,
        errorCount
      } = getResponseCounts(resp);
      if (errorCount > 0) {
        const title = _i18n.i18n.translate('xpack.ml.management.syncSavedObjectsFlyout.sync.error', {
          defaultMessage: 'Some jobs or trained models cannot be synchronized.'
        });
        displayErrorToast(resp, title);
        return;
      }
      displaySuccessToast(_i18n.i18n.translate('xpack.ml.management.syncSavedObjectsFlyout.sync.success', {
        defaultMessage: '{successCount} {successCount, plural, one {item} other {items}} synchronized',
        values: {
          successCount
        }
      }));
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    maxWidth: 600,
    onClose: onClose,
    "data-test-subj": "mlJobMgmtSyncFlyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.management.syncSavedObjectsFlyout.headerLabel",
    defaultMessage: "Synchronize saved objects"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.management.syncSavedObjectsFlyout.description",
    defaultMessage: "Synchronize the saved objects if they are out of sync with the machine learning jobs in Elasticsearch."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_sync_list.SyncList, {
    syncItems: syncResp
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: onClose,
    flush: "left",
    "data-test-subj": "mlJobMgmtSyncFlyoutCloseButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.management.syncSavedObjectsFlyout.closeButton",
    defaultMessage: "Close"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: sync,
    fill: true,
    isDisabled: canSync === false || loading === true,
    "data-test-subj": "mlJobMgmtSyncFlyoutSyncButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.management.syncSavedObjectsFlyout.syncButton",
    defaultMessage: "Synchronize"
  })))))));
};
exports.JobSpacesSyncFlyout = JobSpacesSyncFlyout;
function getResponseCounts(resp) {
  let successCount = 0;
  let errorCount = 0;
  Object.values(resp).forEach(result => {
    Object.values(result).forEach(type => {
      Object.values(type).forEach(({
        success,
        error
      }) => {
        if (success === true) {
          successCount++;
        } else if (error !== undefined) {
          errorCount++;
        }
      });
    });
  });
  return {
    successCount,
    errorCount
  };
}