"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useJobSelection = void 0;
var _lodash = require("lodash");
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _mlUrlState = require("@kbn/ml-url-state");
var _kibana = require("../../contexts/kibana");
var _use_job_selection_flyout = require("../../contexts/ml/use_job_selection_flyout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// check that the ids read from the url exist by comparing them to the
// jobs loaded via mlJobsService.
function getInvalidJobIds(jobs, ids) {
  return ids.filter(id => {
    const jobExists = jobs.some(job => job.job_id === id);
    return jobExists === false && id !== '*';
  });
}
const useJobSelection = jobs => {
  var _globalState$ml2, _globalState$ml4;
  const [globalState, setGlobalState] = (0, _mlUrlState.useUrlState)('_g');
  const {
    toasts: toastNotifications
  } = (0, _kibana.useNotifications)();
  const getJobSelection = (0, _use_job_selection_flyout.useJobSelectionFlyout)();
  const tmpIds = (0, _react.useMemo)(() => {
    var _globalState$ml;
    const ids = (globalState === null || globalState === void 0 ? void 0 : (_globalState$ml = globalState.ml) === null || _globalState$ml === void 0 ? void 0 : _globalState$ml.jobIds) || [];
    return (typeof ids === 'string' ? [ids] : ids).map(id => String(id));
  }, [globalState === null || globalState === void 0 ? void 0 : (_globalState$ml2 = globalState.ml) === null || _globalState$ml2 === void 0 ? void 0 : _globalState$ml2.jobIds]);
  const invalidIds = (0, _react.useMemo)(() => {
    return getInvalidJobIds(jobs, tmpIds);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [tmpIds]);
  const validIds = (0, _react.useMemo)(() => {
    const res = (0, _lodash.difference)(tmpIds, invalidIds);
    res.sort();
    return res;
  }, [tmpIds, invalidIds]);
  const jobSelection = (0, _react.useMemo)(() => {
    var _globalState$ml$group, _globalState$ml3;
    const selectedGroups = (_globalState$ml$group = globalState === null || globalState === void 0 ? void 0 : (_globalState$ml3 = globalState.ml) === null || _globalState$ml3 === void 0 ? void 0 : _globalState$ml3.groups) !== null && _globalState$ml$group !== void 0 ? _globalState$ml$group : [];
    return {
      jobIds: validIds,
      selectedGroups
    };
  }, [validIds, globalState === null || globalState === void 0 ? void 0 : (_globalState$ml4 = globalState.ml) === null || _globalState$ml4 === void 0 ? void 0 : _globalState$ml4.groups]);
  (0, _react.useEffect)(() => {
    if (invalidIds.length > 0) {
      toastNotifications.addWarning(_i18n.i18n.translate('xpack.ml.jobSelect.requestedJobsDoesNotExistWarningMessage', {
        defaultMessage: `Requested
{invalidIdsLength, plural, one {job {invalidIds} does not exist} other {jobs {invalidIds} do not exist}}`,
        values: {
          invalidIdsLength: invalidIds.length,
          invalidIds: invalidIds.join()
        }
      }));
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [invalidIds]);
  (0, _react.useEffect)(() => {
    // if there are no valid ids, ask the user to provide job selection with the flyout
    if (validIds.length === 0 && jobs.length > 0) {
      getJobSelection({
        singleSelection: false
      }).then(({
        jobIds,
        time
      }) => {
        const mlGlobalState = (globalState === null || globalState === void 0 ? void 0 : globalState.ml) || {};
        mlGlobalState.jobIds = jobIds;
        setGlobalState({
          ...{
            ml: mlGlobalState
          },
          ...(time !== undefined ? {
            time
          } : {})
        });
      }).catch(() => {
        // flyout closed without selection
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobs, validIds, setGlobalState, globalState === null || globalState === void 0 ? void 0 : globalState.ml]);
  return jobSelection;
};
exports.useJobSelection = useJobSelection;