"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobMessages = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _uiTheme = require("@kbn/ui-theme");
var _job_message_icon = require("../job_message_icon");
var _date_utils = require("../../../../common/util/date_utils");
var _component_utils = require("../../util/component_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Component for rendering job messages for anomaly detection
 * and data frame analytics jobs.
 */
const JobMessages = ({
  messages,
  loading,
  error,
  refreshMessage,
  actionHandler
}) => {
  const columns = [{
    name: refreshMessage ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.ml.jobMessages.refreshLabel', {
        defaultMessage: 'Refresh'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: (0, _component_utils.blurButtonOnClick)(() => {
        refreshMessage();
      }),
      iconType: "refresh",
      "aria-label": _i18n.i18n.translate('xpack.ml.jobMessages.refreshAriaLabel', {
        defaultMessage: 'Refresh'
      })
    })) : '',
    render: message => /*#__PURE__*/_react.default.createElement(_job_message_icon.JobIcon, {
      message: message
    }),
    width: `${_uiTheme.euiLightVars.euiSizeL}`
  }, {
    field: 'timestamp',
    name: _i18n.i18n.translate('xpack.ml.jobMessages.timeLabel', {
      defaultMessage: 'Time'
    }),
    render: _date_utils.timeFormatter,
    width: '120px',
    sortable: true
  }, {
    field: 'node_name',
    name: _i18n.i18n.translate('xpack.ml.jobMessages.nodeLabel', {
      defaultMessage: 'Node'
    }),
    width: '150px'
  }, {
    field: 'message',
    name: _i18n.i18n.translate('xpack.ml.jobMessages.messageLabel', {
      defaultMessage: 'Message'
    }),
    width: '50%'
  }];
  if (typeof actionHandler === 'function') {
    columns.push({
      name: _i18n.i18n.translate('xpack.ml.jobMessages.actionsLabel', {
        defaultMessage: 'Actions'
      }),
      width: '10%',
      actions: [{
        render: message => {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.ml.jobMessages.toggleInChartTooltipText",
              defaultMessage: "Toggle in chart"
            })
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
            size: "xs",
            "aria-label": _i18n.i18n.translate('xpack.ml.jobMessages.toggleInChartAriaLabel', {
              defaultMessage: 'Toggle in chart'
            }),
            iconType: "visAreaStacked",
            onClick: () => actionHandler(message)
          }));
        }
      }]
    });
  }
  const defaultSorting = {
    sort: {
      field: 'timestamp',
      direction: 'desc'
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: messages,
    columns: columns,
    sorting: defaultSorting,
    compressed: true,
    loading: loading,
    error: error,
    pagination: true,
    "data-test-subj": 'mlAnalyticsDetailsJobMessagesTable'
  }));
};
exports.JobMessages = JobMessages;