"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ItemsGridPagination = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * React component for the pagination controls of the items grid.
 */

function getContextMenuItemIcon(menuItemSetting, itemsPerPage) {
  return menuItemSetting === itemsPerPage ? 'check' : 'empty';
}
class ItemsGridPagination extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onButtonClick", () => {
      this.setState({
        isPopoverOpen: !this.state.isPopoverOpen
      });
    });
    (0, _defineProperty2.default)(this, "closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "onPageClick", pageNumber => {
      this.props.setActivePage(pageNumber);
    });
    (0, _defineProperty2.default)(this, "onChangeItemsPerPage", pageSize => {
      this.closePopover();
      this.props.setItemsPerPage(pageSize);
    });
    this.state = {
      isPopoverOpen: false
    };
  }
  render() {
    const {
      itemCount,
      itemsPerPage,
      itemsPerPageOptions,
      activePage
    } = this.props;
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      color: "text",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: this.onButtonClick
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.itemsGrid.itemsPerPageButtonLabel",
      defaultMessage: "Items per page: {itemsPerPage}",
      values: {
        itemsPerPage
      }
    }));
    const pageCount = Math.ceil(itemCount / itemsPerPage);
    const items = itemsPerPageOptions.map(pageSize => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: `${pageSize} items`,
        icon: getContextMenuItemIcon(pageSize, itemsPerPage),
        onClick: () => {
          this.onChangeItemsPerPage(pageSize);
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.itemsGrid.itemsCountLabel",
        defaultMessage: "{pageSize} items",
        values: {
          pageSize
        }
      }));
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "customizablePagination",
      button: button,
      isOpen: this.state.isPopoverOpen,
      closePopover: this.closePopover,
      panelPaddingSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      items: items,
      className: "ml-items-grid-page-size-menu"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
      pageCount: pageCount,
      activePage: activePage,
      onPageClick: this.onPageClick
    })));
  }
}
exports.ItemsGridPagination = ItemsGridPagination;
ItemsGridPagination.propTypes = {
  itemCount: _propTypes.default.number.isRequired,
  itemsPerPage: _propTypes.default.number.isRequired,
  itemsPerPageOptions: _propTypes.default.arrayOf(_propTypes.default.number).isRequired,
  setItemsPerPage: _propTypes.default.func.isRequired,
  activePage: _propTypes.default.number.isRequired,
  setActivePage: _propTypes.default.func.isRequired
};