"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportJobsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _kibana = require("../../../contexts/kibana");
var _cannot_import_jobs_callout = require("./cannot_import_jobs_callout");
var _cannot_read_file_callout = require("./cannot_read_file_callout");
var _toast_notification_service = require("../../../services/toast_notification_service");
var _jobs_import_service = require("./jobs_import_service");
var _validate = require("./validate");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ImportJobsFlyout = ({
  isDisabled
}) => {
  const {
    jobs: {
      bulkCreateJobs
    },
    dataFrameAnalytics: {
      createDataFrameAnalytics
    },
    filters: {
      filters: getFilters
    }
  } = (0, _kibana.useMlApiContext)();
  const {
    services: {
      data: {
        dataViews: {
          getTitles: getDataViewTitles
        }
      },
      notifications: {
        toasts
      },
      mlServices: {
        mlUsageCollection
      }
    }
  } = (0, _kibana.useMlKibana)();
  const jobImportService = (0, _react.useMemo)(() => new _jobs_import_service.JobImportService(), []);
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const [adJobs, setAdJobs] = (0, _react.useState)([]);
  const [dfaJobs, setDfaJobs] = (0, _react.useState)([]);
  const [jobIdObjects, setJobIdObjects] = (0, _react.useState)([]);
  const [skippedJobs, setSkippedJobs] = (0, _react.useState)([]);
  const [importing, setImporting] = (0, _react.useState)(false);
  const [jobType, setJobType] = (0, _react.useState)(null);
  const [totalJobsRead, setTotalJobsRead] = (0, _react.useState)(0);
  const [importDisabled, setImportDisabled] = (0, _react.useState)(true);
  const [deleteDisabled, setDeleteDisabled] = (0, _react.useState)(true);
  const [idsMash, setIdsMash] = (0, _react.useState)('');
  const [validatingJobs, setValidatingJobs] = (0, _react.useState)(false);
  const [showFileReadError, setShowFileReadError] = (0, _react.useState)(false);
  const {
    displayErrorToast,
    displaySuccessToast
  } = (0, _react.useMemo)(() => (0, _toast_notification_service.toastNotificationServiceProvider)(toasts), [toasts]);
  const [validateIds] = (0, _validate.useValidateIds)(jobType, jobIdObjects, idsMash, setJobIdObjects, setValidatingJobs);
  (0, _useDebounce.default)(validateIds, 400, [idsMash]);
  const reset = (0, _react.useCallback)((showFileError = false) => {
    setAdJobs([]);
    setDfaJobs([]);
    setJobIdObjects([]);
    setIdsMash('');
    setImporting(false);
    setJobType(null);
    setTotalJobsRead(0);
    setValidatingJobs(false);
    setShowFileReadError(showFileError);
  }, []);
  (0, _react.useEffect)(function onFlyoutChange() {
    reset();
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [showFlyout]);
  function toggleFlyout() {
    setShowFlyout(!showFlyout);
  }
  const onFilePickerChange = (0, _react.useCallback)(async files => {
    setShowFileReadError(false);
    if (files.length === 0) {
      reset();
      return;
    }
    try {
      const loadedFile = await jobImportService.readJobConfigs(files[0]);
      if (loadedFile.jobType === null) {
        reset(true);
        return;
      }
      setTotalJobsRead(loadedFile.jobs.length);
      const validatedJobs = await jobImportService.validateJobs(loadedFile.jobs, loadedFile.jobType, getDataViewTitles, getFilters);
      if (loadedFile.jobType === 'anomaly-detector') {
        const tempJobs = loadedFile.jobs.filter(j => validatedJobs.jobs.map(({
          jobId
        }) => jobId).includes(j.job.job_id));
        setAdJobs(tempJobs);
      } else if (loadedFile.jobType === 'data-frame-analytics') {
        const tempJobs = loadedFile.jobs.filter(j => validatedJobs.jobs.map(({
          jobId
        }) => jobId).includes(j.id));
        setDfaJobs(tempJobs);
      }
      setJobType(loadedFile.jobType);
      setJobIdObjects(validatedJobs.jobs.map(({
        jobId,
        destIndex
      }) => ({
        jobId,
        originalId: jobId,
        jobIdValid: true,
        jobIdInvalidMessage: '',
        jobIdValidated: false,
        destIndex,
        originalDestIndex: destIndex,
        destIndexValid: true,
        destIndexInvalidMessage: '',
        destIndexValidated: false
      })));
      const ids = createIdsMash(validatedJobs.jobs, loadedFile.jobType);
      setIdsMash(ids);
      setValidatingJobs(true);
      setSkippedJobs(validatedJobs.skippedJobs);
    } catch (error) {
      displayErrorToast(error);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const onImport = (0, _react.useCallback)(async () => {
    setImporting(true);
    if (jobType === 'anomaly-detector') {
      const renamedJobs = jobImportService.renameAdJobs(jobIdObjects, adJobs);
      try {
        await bulkCreateADJobs(renamedJobs);
        mlUsageCollection.count('imported_anomaly_detector_jobs', renamedJobs.length);
      } catch (error) {
        // display unexpected error
        displayErrorToast(error);
      }
    } else if (jobType === 'data-frame-analytics') {
      const renamedJobs = jobImportService.renameDfaJobs(jobIdObjects, dfaJobs);
      await bulkCreateDfaJobs(renamedJobs);
      mlUsageCollection.count('imported_data_frame_analytics_jobs', renamedJobs.length);
    }
    setImporting(false);
    setShowFlyout(false);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobType, jobIdObjects, adJobs, dfaJobs]);
  const bulkCreateADJobs = (0, _react.useCallback)(async jobs => {
    const results = await bulkCreateJobs(jobs);
    let successCount = 0;
    const errors = [];
    const failedJobIds = new Set();
    Object.entries(results).forEach(([jobId, {
      job,
      datafeed
    }]) => {
      if (job.error || datafeed.error) {
        failedJobIds.add(jobId);
        if (job.error) {
          errors.push(job.error);
        }
        if (datafeed.error) {
          errors.push(datafeed.error);
        }
      } else {
        successCount++;
      }
    });
    if (successCount > 0) {
      displayImportSuccessToast(successCount);
    }
    if (errors.length > 0) {
      displayImportErrorToast(errors, failedJobIds.size);
      mlUsageCollection.count('import_failed_anomaly_detector_jobs', failedJobIds.size);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const bulkCreateDfaJobs = (0, _react.useCallback)(async jobs => {
    const errors = [];
    const results = await Promise.all(jobs.map(async ({
      id,
      ...config
    }) => {
      try {
        return await createDataFrameAnalytics(id, config);
      } catch (error) {
        errors.push(error);
      }
    }));
    const successCount = Object.values(results).filter(job => job !== undefined).length;
    if (successCount > 0) {
      displayImportSuccessToast(successCount);
    }
    if (errors.length > 0) {
      displayImportErrorToast(errors, errors.length);
      mlUsageCollection.count('import_failed_data_frame_analytics_jobs', errors.length);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const displayImportSuccessToast = (0, _react.useCallback)(count => {
    const title = _i18n.i18n.translate('xpack.ml.importExport.importFlyout.importJobSuccessToast', {
      defaultMessage: '{count, plural, one {# job} other {# jobs}} successfully imported',
      values: {
        count
      }
    });
    displaySuccessToast(title);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const displayImportErrorToast = (0, _react.useCallback)((errors, failureCount) => {
    const title = _i18n.i18n.translate('xpack.ml.importExport.importFlyout.importJobErrorToast', {
      defaultMessage: '{count, plural, one {# job} other {# jobs}} failed to import correctly',
      values: {
        count: failureCount
      }
    });
    const errorList = errors.map(_mlErrorUtils.extractErrorProperties);
    displayErrorToast(errorList, title);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const deleteJob = (0, _react.useCallback)(index => {
    if (jobType === 'anomaly-detector') {
      const js = [...adJobs];
      js.splice(index, 1);
      setAdJobs(js);
    } else if (jobType === 'data-frame-analytics') {
      const js = [...dfaJobs];
      js.splice(index, 1);
      setDfaJobs(js);
    }
    const js = [...jobIdObjects];
    js.splice(index, 1);
    setJobIdObjects(js);
    const ids = createIdsMash(js, jobType);
    setIdsMash(ids);
    setValidatingJobs(true);
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [jobIdObjects, adJobs, dfaJobs]);
  (0, _react.useEffect)(() => {
    const disabled = jobIdObjects.length === 0 || importing === true || validatingJobs === true || jobIdObjects.some(({
      jobIdValid,
      destIndexValid
    }) => jobIdValid === false || destIndexValid === false);
    setImportDisabled(disabled);
    setDeleteDisabled(importing === true || validatingJobs === true);
  }, [jobIdObjects, idsMash, validatingJobs, importing]);
  const renameJob = (0, _react.useCallback)((id, i) => {
    jobIdObjects[i].jobId = id;
    jobIdObjects[i].jobIdValid = false;
    jobIdObjects[i].jobIdValidated = false;
    setJobIdObjects([...jobIdObjects]);
    const ids = createIdsMash(jobIdObjects, jobType);
    setIdsMash(ids);
    setValidatingJobs(true);
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [jobIdObjects]);
  const renameDestIndex = (0, _react.useCallback)((id, i) => {
    jobIdObjects[i].destIndex = id;
    jobIdObjects[i].destIndexValid = false;
    jobIdObjects[i].destIndexValidated = false;
    jobIdObjects[i].destIndexInvalidMessage = '';
    setJobIdObjects([...jobIdObjects]);
    const ids = createIdsMash(jobIdObjects, jobType);
    setIdsMash(ids);
    setValidatingJobs(true);
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [jobIdObjects]);
  const DeleteJobButton = ({
    index
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "trash",
    "aria-label": _i18n.i18n.translate('xpack.ml.importExport.importFlyout.deleteButtonAria', {
      defaultMessage: 'Delete'
    }),
    color: deleteDisabled ? 'text' : 'danger',
    disabled: deleteDisabled,
    onClick: () => deleteJob(index)
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FlyoutButton, {
    onClick: toggleFlyout,
    isDisabled: isDisabled
  }), showFlyout === true && isDisabled === false && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: setShowFlyout.bind(null, false),
    hideCloseButton: true,
    size: "m",
    "data-test-subj": "mlJobMgmtImportJobsFlyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.importExport.importFlyout.flyoutHeader",
    defaultMessage: "Import jobs"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    disabled: importing,
    fullWidth: true,
    id: "filePicker",
    initialPromptText: _i18n.i18n.translate('xpack.ml.importExport.importFlyout.fileSelect', {
      defaultMessage: 'Select or drag and drop a file'
    }),
    onChange: onFilePickerChange,
    className: "file-datavisualizer-file-picker"
  })), showFileReadError ? /*#__PURE__*/_react.default.createElement(_cannot_read_file_callout.CannotReadFileCallout, null) : null, totalJobsRead > 0 && jobType !== null && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlJobMgmtImportJobsFileRead"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), jobType === 'anomaly-detector' && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlJobMgmtImportJobsADTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.importExport.importFlyout.selectedFiles.ad",
    defaultMessage: "{num} anomaly detection {num, plural, one {job} other {jobs}} read from file",
    values: {
      num: totalJobsRead
    }
  })), jobType === 'data-frame-analytics' && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlJobMgmtImportJobsDFATitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.importExport.importFlyout.selectedFiles.dfa",
    defaultMessage: "{num} data frame analytics {num, plural, one {job} other {jobs}} read from file",
    values: {
      num: totalJobsRead
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_cannot_import_jobs_callout.CannotImportJobsCallout, {
    jobs: skippedJobs,
    autoExpand: jobIdObjects.length === 0 || skippedJobs.length === 1
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.importExport.importFlyout.importableFiles",
    defaultMessage: "Import {num, plural, one {# job} other {# jobs}}",
    values: {
      num: jobIdObjects.length
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), jobIdObjects.map((jobId, i) => /*#__PURE__*/_react.default.createElement("div", {
    key: jobId.originalId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: jobId.jobIdInvalidMessage,
    isInvalid: jobId.jobIdValid === false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    prepend: _i18n.i18n.translate('xpack.ml.importExport.importFlyout.jobId', {
      defaultMessage: 'Job ID'
    }),
    disabled: importing,
    compressed: true,
    value: jobId.jobId,
    onChange: e => renameJob(e.target.value, i),
    isInvalid: jobId.jobIdValid === false,
    "data-test-subj": "mlJobMgmtImportJobIdInput"
  })), jobType === 'data-frame-analytics' && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: jobId.destIndexValid === true ? jobId.destIndexInvalidMessage : '',
    error: jobId.destIndexValid === false ? jobId.destIndexInvalidMessage : '',
    isInvalid: jobId.destIndexValid === false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    prepend: _i18n.i18n.translate('xpack.ml.importExport.importFlyout.destIndex', {
      defaultMessage: 'Destination index'
    }),
    disabled: importing,
    compressed: true,
    value: jobId.destIndex,
    onChange: e => renameDestIndex(e.target.value, i),
    isInvalid: jobId.destIndexValid === false
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(DeleteJobButton, {
    index: i
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: setShowFlyout.bind(null, false),
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.importExport.importFlyout.closeButton",
    defaultMessage: "Close"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: importDisabled,
    onClick: onImport,
    fill: true,
    "data-test-subj": "mlJobMgmtImportImportButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.importExport.importFlyout.closeButton.importButton",
    defaultMessage: "Import"
  })))))));
};
exports.ImportJobsFlyout = ImportJobsFlyout;
const FlyoutButton = ({
  isDisabled,
  onClick
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "importAction",
    onClick: onClick,
    isDisabled: isDisabled,
    "data-test-subj": "mlJobsImportButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.importExport.importButton",
    defaultMessage: "Import jobs"
  }));
};
function createIdsMash(jobIdObjects, jobType) {
  return jobIdObjects.map(({
    jobId
  }) => jobId).join('') + (jobType === 'data-frame-analytics' ? jobIdObjects.map(({
    destIndex
  }) => destIndex).join('') : '');
}