"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExportJobsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _kibana = require("../../../contexts/kibana");
var _export_job_warning_callout = require("./export_job_warning_callout");
var _jobs_export_service = require("./jobs_export_service");
var _toast_notification_service = require("../../../services/toast_notification_service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExportJobsFlyout = ({
  isDisabled,
  currentTab
}) => {
  const mlApiServices = (0, _kibana.useMlApiContext)();
  const {
    getJobs,
    dataFrameAnalytics: {
      getDataFrameAnalytics
    }
  } = mlApiServices;
  const {
    services: {
      notifications: {
        toasts
      },
      mlServices: {
        mlUsageCollection
      }
    }
  } = (0, _kibana.useMlKibana)();

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const jobsExportService = (0, _react.useMemo)(() => new _jobs_export_service.JobsExportService(mlApiServices), []);
  const [loadingADJobs, setLoadingADJobs] = (0, _react.useState)(true);
  const [loadingDFAJobs, setLoadingDFAJobs] = (0, _react.useState)(true);
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const [adJobIds, setAdJobIds] = (0, _react.useState)([]);
  const [dfaJobIds, setDfaJobIds] = (0, _react.useState)([]);
  const [selectedJobIds, setSelectedJobIds] = (0, _react.useState)([]);
  const [exporting, setExporting] = (0, _react.useState)(false);
  const [selectedJobType, setSelectedJobType] = (0, _react.useState)(currentTab);
  const [switchTabConfirmVisible, setSwitchTabConfirmVisible] = (0, _react.useState)(false);
  const [switchTabNextTab, setSwitchTabNextTab] = (0, _react.useState)(currentTab);
  const {
    displayErrorToast,
    displaySuccessToast
  } = (0, _react.useMemo)(() => (0, _toast_notification_service.toastNotificationServiceProvider)(toasts), [toasts]);
  const [jobDependencies, setJobDependencies] = (0, _react.useState)([]);
  const [selectedJobDependencies, setSelectedJobDependencies] = (0, _react.useState)([]);
  (0, _react.useEffect)(function onFlyoutChange() {
    setLoadingADJobs(true);
    setLoadingDFAJobs(true);
    setAdJobIds([]);
    setSelectedJobIds([]);
    setExporting(false);
    setSelectedJobType(currentTab);
    setSwitchTabConfirmVisible(false);
    if (showFlyout) {
      getJobs().then(({
        jobs
      }) => {
        setLoadingADJobs(false);
        setAdJobIds(jobs.map(j => j.job_id));
        jobsExportService.getJobDependencies(jobs).then(jobDeps => {
          setJobDependencies(jobDeps);
          setLoadingADJobs(false);
        }).catch(error => {
          const errorTitle = _i18n.i18n.translate('xpack.ml.importExport.exportFlyout.calendarsError', {
            defaultMessage: 'Could not load calendars'
          });
          displayErrorToast(error, errorTitle);
        });
      }).catch(error => {
        const errorTitle = _i18n.i18n.translate('xpack.ml.importExport.exportFlyout.adJobsError', {
          defaultMessage: 'Could not load anomaly detection jobs'
        });
        displayErrorToast(error, errorTitle);
      });
      getDataFrameAnalytics().then(({
        data_frame_analytics: dataFrameAnalytics
      }) => {
        setLoadingDFAJobs(false);
        setDfaJobIds(dataFrameAnalytics.map(j => j.id));
      }).catch(error => {
        const errorTitle = _i18n.i18n.translate('xpack.ml.importExport.exportFlyout.dfaJobsError', {
          defaultMessage: 'Could not load data frame analytics jobs'
        });
        displayErrorToast(error, errorTitle);
      });
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [showFlyout]);
  function toggleFlyout() {
    setShowFlyout(!showFlyout);
  }
  async function onExport() {
    setExporting(true);
    const title = _i18n.i18n.translate('xpack.ml.importExport.exportFlyout.exportDownloading', {
      defaultMessage: 'Your file is downloading in the background'
    });
    displaySuccessToast(title);
    try {
      if (selectedJobType === 'anomaly-detector') {
        await jobsExportService.exportAnomalyDetectionJobs(selectedJobIds);
      } else {
        await jobsExportService.exportDataframeAnalyticsJobs(selectedJobIds);
      }
      mlUsageCollection.count(selectedJobType === 'anomaly-detector' ? 'exported_anomaly_detector_jobs' : 'exported_data_frame_analytics_jobs', selectedJobIds.length);
      setExporting(false);
      setShowFlyout(false);
    } catch (error) {
      const errorTitle = _i18n.i18n.translate('xpack.ml.importExport.exportFlyout.exportError', {
        defaultMessage: 'Could not export selected jobs'
      });
      displayErrorToast(error, errorTitle);
      setExporting(false);
    }
  }
  function toggleSelectedJob(checked, id) {
    if (checked) {
      setSelectedJobIds([...selectedJobIds, id]);
    } else {
      setSelectedJobIds(selectedJobIds.filter(id2 => id2 !== id));
    }
  }
  const attemptTabSwitch = (0, _react.useCallback)(jobType => {
    if (jobType === selectedJobType) {
      return;
    }
    // if the user has already selected some jobs, open a confirm modal
    // rather than changing tabs
    if (selectedJobIds.length > 0) {
      setSwitchTabNextTab(jobType);
      setSwitchTabConfirmVisible(true);
      return;
    }
    switchTab(jobType);
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [selectedJobIds]);
  (0, _react.useEffect)(() => {
    setSelectedJobDependencies(jobDependencies.filter(({
      jobId
    }) => selectedJobIds.includes(jobId)));
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selectedJobIds]);
  function switchTab(jobType) {
    setSwitchTabConfirmVisible(false);
    setSelectedJobIds([]);
    setSelectedJobType(jobType);
  }
  function onSelectAll() {
    const ids = selectedJobType === 'anomaly-detector' ? adJobIds : dfaJobIds;
    if (selectedJobIds.length === ids.length) {
      setSelectedJobIds([]);
    } else {
      setSelectedJobIds([...ids]);
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FlyoutButton, {
    onClick: toggleFlyout,
    isDisabled: isDisabled
  }), showFlyout === true && isDisabled === false && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => setShowFlyout(false),
    hideCloseButton: true,
    size: "s",
    "data-test-subj": "mlJobMgmtExportJobsFlyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.importExport.exportFlyout.flyoutHeader",
    defaultMessage: "Export jobs"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_export_job_warning_callout.ExportJobDependenciesWarningCallout, {
    jobs: selectedJobDependencies
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: selectedJobType === 'anomaly-detector',
    onClick: () => attemptTabSwitch('anomaly-detector'),
    disabled: exporting,
    "data-test-subj": "mlJobMgmtExportJobsADTab"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.importExport.exportFlyout.adTab",
    defaultMessage: "Anomaly detection"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: selectedJobType === 'data-frame-analytics',
    onClick: () => attemptTabSwitch('data-frame-analytics'),
    disabled: exporting,
    "data-test-subj": "mlJobMgmtExportJobsDFATab"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.importExport.exportFlyout.dfaTab",
    defaultMessage: "Analytics"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, selectedJobType === 'anomaly-detector' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, loadingADJobs === true ? /*#__PURE__*/_react.default.createElement(LoadingSpinner, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    onClick: onSelectAll,
    isDisabled: isDisabled,
    "data-test-subj": "mlJobMgmtExportJobsSelectAllButton"
  }, selectedJobIds.length === adJobIds.length ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.importExport.exportFlyout.adDeselectAllButton",
    defaultMessage: "Deselect all"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.importExport.exportFlyout.adSelectAllButton",
    defaultMessage: "Select all"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlJobMgmtExportJobsADJobList"
  }, adJobIds.map(id => /*#__PURE__*/_react.default.createElement("div", {
    key: id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: id,
    label: id,
    checked: selectedJobIds.includes(id),
    onChange: e => toggleSelectedJob(e.target.checked, id)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })))))), selectedJobType === 'data-frame-analytics' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, loadingDFAJobs === true ? /*#__PURE__*/_react.default.createElement(LoadingSpinner, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    onClick: onSelectAll,
    isDisabled: isDisabled,
    "data-test-subj": "mlJobMgmtExportJobsSelectAllButton"
  }, selectedJobIds.length === dfaJobIds.length ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.importExport.exportFlyout.dfaDeselectAllButton",
    defaultMessage: "Deselect all"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.importExport.exportFlyout.dfaSelectAllButton",
    defaultMessage: "Select all"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlJobMgmtExportJobsDFAJobList"
  }, dfaJobIds.map(id => /*#__PURE__*/_react.default.createElement("div", {
    key: id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: id,
    label: id,
    checked: selectedJobIds.includes(id),
    onChange: e => toggleSelectedJob(e.target.checked, id)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: setShowFlyout.bind(null, false),
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.importExport.exportFlyout.closeButton",
    defaultMessage: "Close"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: selectedJobIds.length === 0 || exporting === true,
    onClick: onExport,
    fill: true,
    "data-test-subj": "mlJobMgmtExportExportButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.importExport.exportFlyout.exportButton",
    defaultMessage: "Export"
  })))))), switchTabConfirmVisible === true ? /*#__PURE__*/_react.default.createElement(SwitchTabsConfirm, {
    onCancel: setSwitchTabConfirmVisible.bind(null, false),
    onConfirm: () => switchTab(switchTabNextTab)
  }) : null));
};
exports.ExportJobsFlyout = ExportJobsFlyout;
const FlyoutButton = ({
  isDisabled,
  onClick
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "exportAction",
    onClick: onClick,
    isDisabled: isDisabled,
    "data-test-subj": "mlJobsExportButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.importExport.exportButton",
    defaultMessage: "Export jobs"
  }));
};
const LoadingSpinner = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "spaceAround"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
  size: "l"
}))));
const SwitchTabsConfirm = ({
  onCancel,
  onConfirm
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
  title: _i18n.i18n.translate('xpack.ml.importExport.exportFlyout.switchTabsConfirm.title', {
    defaultMessage: 'Change tabs?'
  }),
  onCancel: onCancel,
  onConfirm: onConfirm,
  cancelButtonText: _i18n.i18n.translate('xpack.ml.importExport.exportFlyout.switchTabsConfirm.cancelButton', {
    defaultMessage: 'Cancel'
  }),
  confirmButtonText: _i18n.i18n.translate('xpack.ml.importExport.exportFlyout.switchTabsConfirm.confirmButton', {
    defaultMessage: 'Confirm'
  }),
  defaultFocusedButton: "confirm"
}, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.ml.importExport.exportFlyout.switchTabsConfirm.text",
  defaultMessage: "Changing tabs will clear currently selected jobs"
})));