"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HelpPopoverButton = exports.HelpPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
require("./help_popover.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HelpPopoverButton = ({
  onClick
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    className: "mlHelpPopover__buttonIcon",
    size: "s",
    iconType: "help",
    "aria-label": _i18n.i18n.translate('xpack.ml.helpPopover.ariaLabel', {
      defaultMessage: 'Help'
    }),
    onClick: onClick
  });
};
exports.HelpPopoverButton = HelpPopoverButton;
const HelpPopover = ({
  anchorPosition,
  children,
  title
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: anchorPosition,
    button: /*#__PURE__*/_react.default.createElement(HelpPopoverButton, {
      onClick: setIsPopoverOpen.bind(null, !isPopoverOpen)
    }),
    className: "mlHelpPopover",
    closePopover: setIsPopoverOpen.bind(null, false),
    isOpen: isPopoverOpen,
    ownFocus: true,
    panelClassName: "mlHelpPopover__panel",
    panelPaddingSize: "none"
  }, title && /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "mlHelpPopover__content",
    size: "s"
  }, children));
};
exports.HelpPopover = HelpPopover;