"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HelpMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _kibana = require("../../contexts/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Component for adding a documentation link to the help menu
const HelpMenu = /*#__PURE__*/_react.default.memo(({
  docLink,
  appName
}) => {
  const {
    chrome
  } = (0, _kibana.useMlKibana)().services;
  (0, _react.useEffect)(() => {
    chrome.setHelpExtension({
      appName: appName !== null && appName !== void 0 ? appName : _i18n.i18n.translate('xpack.ml.chrome.help.appName', {
        defaultMessage: 'Machine Learning'
      }),
      links: [{
        href: docLink,
        linkType: 'documentation'
      }]
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return null;
});
exports.HelpMenu = HelpMenu;
HelpMenu.displayName = 'HelpMenu';