"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _entity_control = require("../../timeseriesexplorer/components/entity_control/entity_control");
var _field_types = require("../../../../common/constants/field_types");
var _anomaly_utils = require("../../../../common/util/anomaly_utils");
var _component_utils = require("../../util/component_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getAddFilter({
  entityName,
  entityValue,
  filter
}) {
  if (filter !== undefined) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomaliesTable.entityCell.addFilterTooltip",
        defaultMessage: "Add filter"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      "data-test-subj": `mlAnomaliesTableEntityCellAddFilterButton-${entityValue}`,
      className: "filter-button",
      onClick: (0, _component_utils.blurButtonOnClick)(() => {
        filter(entityName, entityValue, _anomaly_utils.ENTITY_FIELD_OPERATIONS.ADD);
      }),
      iconType: "plusInCircle",
      "aria-label": _i18n.i18n.translate('xpack.ml.anomaliesTable.entityCell.addFilterAriaLabel', {
        defaultMessage: 'Add filter'
      })
    }));
  }
}
function getRemoveFilter({
  entityName,
  entityValue,
  filter
}) {
  if (filter !== undefined) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomaliesTable.entityCell.removeFilterTooltip",
        defaultMessage: "Remove filter"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      "data-test-subj": `mlAnomaliesTableEntityCellRemoveFilterButton-${entityValue}`,
      className: "filter-button",
      onClick: (0, _component_utils.blurButtonOnClick)(() => {
        filter(entityName, entityValue, _anomaly_utils.ENTITY_FIELD_OPERATIONS.REMOVE);
      }),
      iconType: "minusInCircle",
      "aria-label": _i18n.i18n.translate('xpack.ml.anomaliesTable.entityCell.removeFilterAriaLabel', {
        defaultMessage: 'Remove filter'
      })
    }));
  }
}

/*
 * Component for rendering an entity, displaying the value
 * of the entity, such as a partitioning or influencer field value, and optionally links for
 * adding or removing a filter on this entity.
 */
const EntityCell = ({
  entityName,
  entityValue,
  filter,
  wrapText = false
}) => {
  let valueText = entityValue === '' ? /*#__PURE__*/_react.default.createElement("i", null, _entity_control.EMPTY_FIELD_VALUE_LABEL) : entityValue;
  if (entityName === _field_types.MLCATEGORY) {
    valueText = `${_field_types.MLCATEGORY} ${valueText}`;
  }
  const textStyle = {
    maxWidth: '100%'
  };
  const textWrapperClass = wrapText ? 'field-value-long' : 'field-value-short';
  const shouldDisplayIcons = filter !== undefined && entityName !== undefined && entityValue !== undefined;
  if (wrapText === true) {
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("span", {
      className: textWrapperClass
    }, valueText), shouldDisplayIcons && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, getAddFilter({
      entityName,
      entityValue,
      filter
    }), getRemoveFilter({
      entityName,
      entityValue,
      filter
    })));
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      alignItems: "center",
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      style: textStyle
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      className: textWrapperClass
    }, valueText)), shouldDisplayIcons && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      alignItems: "center",
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, getAddFilter({
      entityName,
      entityValue,
      filter
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, getRemoveFilter({
      entityName,
      entityValue,
      filter
    })))));
  }
};
exports.EntityCell = EntityCell;