"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataGrid = void 0;
var _react = _interopRequireWildcard(require("react"));
var _es_client = require("../../../../common/types/es_client");
var _common = require("../../data_frame_analytics/common");
var _column_chart = require("./column_chart");
var _common2 = require("./common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rowCountDefault = {
  rowCount: 0,
  rowCountRelation: undefined
};
const useDataGrid = (columns, defaultPageSize = 5, defaultVisibleColumnsCount = _common2.INIT_MAX_COLUMNS, defaultVisibleColumnsFilter) => {
  const defaultPagination = {
    pageIndex: 0,
    pageSize: defaultPageSize
  };
  const [ccsWarning, setCcsWarning] = (0, _react.useState)(false);
  const [noDataMessage, setNoDataMessage] = (0, _react.useState)('');
  const [errorMessage, setErrorMessage] = (0, _react.useState)('');
  const [status, setStatus] = (0, _react.useState)(_common.INDEX_STATUS.UNUSED);
  const [rowCountInfo, setRowCountInfo] = (0, _react.useState)(rowCountDefault);
  const [columnCharts, setColumnCharts] = (0, _react.useState)([]);
  const [tableItems, setTableItems] = (0, _react.useState)([]);
  const [pagination, setPagination] = (0, _react.useState)(defaultPagination);
  const [sortingColumns, setSortingColumns] = (0, _react.useState)([]);
  const [chartsVisible, setChartsVisible] = (0, _react.useState)(undefined);
  const {
    rowCount,
    rowCountRelation
  } = rowCountInfo;
  const toggleChartVisibility = () => {
    if (chartsVisible !== undefined) {
      setChartsVisible(!chartsVisible);
    }
  };
  const onChangeItemsPerPage = (0, _react.useCallback)(pageSize => {
    setPagination(p => {
      const pageIndex = Math.floor(p.pageSize * p.pageIndex / pageSize);
      return {
        pageIndex,
        pageSize
      };
    });
  }, []);
  const onChangePage = (0, _react.useCallback)(pageIndex => setPagination(p => ({
    ...p,
    pageIndex
  })), []);
  const resetPagination = () => setPagination(defaultPagination);

  // Column visibility
  const [visibleColumns, setVisibleColumns] = (0, _react.useState)([]);
  const columnIds = columns.map(c => c.id);
  const filteredColumnIds = defaultVisibleColumnsFilter !== undefined ? columnIds.filter(defaultVisibleColumnsFilter) : columnIds;
  const defaultVisibleColumns = filteredColumnIds.splice(0, defaultVisibleColumnsCount);
  (0, _react.useEffect)(() => {
    setVisibleColumns(defaultVisibleColumns);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [defaultVisibleColumns.join()]);
  const [invalidSortingColumnns, setInvalidSortingColumnns] = (0, _react.useState)([]);
  const onSort = (0, _react.useCallback)(sc => {
    // Check if an unsupported column type for sorting was selected.
    const updatedInvalidSortingColumns = sc.reduce((arr, current) => {
      const columnType = columns.find(dgc => dgc.id === current.id);
      if ((columnType === null || columnType === void 0 ? void 0 : columnType.schema) === 'json') {
        arr.push(current.id);
      }
      return arr;
    }, []);
    setInvalidSortingColumnns(updatedInvalidSortingColumns);
    if (updatedInvalidSortingColumns.length === 0) {
      setSortingColumns(sc);
    }
  }, [columns]);
  const columnsWithCharts = (0, _react.useMemo)(() => {
    const updatedColumns = columns.map((c, index) => {
      const chartData = columnCharts.find(cd => cd.id === c.id);
      return {
        ...c,
        display: chartData !== undefined && chartsVisible === true ? /*#__PURE__*/_react.default.createElement(_column_chart.ColumnChart, {
          chartData: chartData,
          columnType: c,
          dataTestSubj: `mlDataGridChart-${c.id}`
        }) : undefined
      };
    });

    // Sort the columns to be in line with the current order of visible columns.
    // EuiDataGrid misses a callback for the order of all available columns, so
    // this only can retain the order of visible columns.
    return updatedColumns.sort((a, b) => {
      // This will always move visible columns above invisible ones.
      if (visibleColumns.indexOf(a.id) === -1 && visibleColumns.indexOf(b.id) > -1) {
        return 1;
      }
      if (visibleColumns.indexOf(b.id) === -1 && visibleColumns.indexOf(a.id) > -1) {
        return -1;
      }
      if (visibleColumns.indexOf(a.id) === -1 && visibleColumns.indexOf(b.id) === -1) {
        return a.id.localeCompare(b.id);
      }

      // If both columns are visible sort by their visible sorting order.
      return visibleColumns.indexOf(a.id) - visibleColumns.indexOf(b.id);
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [columns, columnCharts, chartsVisible, JSON.stringify(visibleColumns)]);

  // Initialize the mini histogram charts toggle button.
  // On load `chartsVisible` is set to `undefined`, the button will be disabled.
  // Once we know how many rows have been returned,
  // we decide whether to show or hide the charts by default.
  (0, _react.useEffect)(() => {
    if (chartsVisible === undefined && rowCount > 0 && rowCountRelation !== undefined) {
      setChartsVisible(rowCount <= _common2.COLUMN_CHART_DEFAULT_VISIBILITY_ROWS_THRESHOLD && rowCountRelation !== _es_client.ES_CLIENT_TOTAL_HITS_RELATION.GTE);
    }
  }, [chartsVisible, rowCount, rowCountRelation]);
  return {
    ccsWarning,
    chartsVisible,
    chartsButtonVisible: true,
    columnsWithCharts,
    errorMessage,
    invalidSortingColumnns,
    noDataMessage,
    onChangeItemsPerPage,
    onChangePage,
    onSort,
    pagination,
    resetPagination,
    rowCount,
    rowCountRelation,
    setColumnCharts,
    setCcsWarning,
    setErrorMessage,
    setNoDataMessage,
    setPagination,
    setRowCountInfo,
    setSortingColumns,
    setStatus,
    setTableItems,
    setVisibleColumns,
    sortingColumns,
    status,
    tableItems,
    toggleChartVisibility,
    visibleColumns
  };
};
exports.useDataGrid = useDataGrid;