"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useColumnChart = exports.hoveredRow$ = exports.getXScaleType = exports.getLegendText = exports.getFieldType = exports.BAR_COLOR = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _rxjs = require("rxjs");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _i18n = require("@kbn/i18n");
var _fieldTypes = require("@kbn/field-types");
var _field_histograms = require("../../../../common/types/field_histograms");
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cssHistogramLegendBoolean = (0, _react2.css)({
  width: '100%',
  // This was originally $euiButtonMinWidth, but that
  // is no longer exported from the EUI package,
  // so we're replicating it here inline.
  minWidth: `calc(${_uiTheme.euiThemeVars.euiSize} * 7)`
});
const cssTextAlignCenter = (0, _react2.css)({
  textAlign: 'center'
});
const hoveredRow$ = new _rxjs.BehaviorSubject(null);
exports.hoveredRow$ = hoveredRow$;
const BAR_COLOR = (0, _eui.euiPaletteColorBlind)()[0];
exports.BAR_COLOR = BAR_COLOR;
const BAR_COLOR_BLUR = (0, _eui.euiPaletteColorBlind)({
  rotations: 2
})[10];
const MAX_CHART_COLUMNS = 20;
const getXScaleType = kbnFieldType => {
  switch (kbnFieldType) {
    case _fieldTypes.KBN_FIELD_TYPES.BOOLEAN:
    case _fieldTypes.KBN_FIELD_TYPES.IP:
    case _fieldTypes.KBN_FIELD_TYPES.STRING:
      return 'ordinal';
    case _fieldTypes.KBN_FIELD_TYPES.DATE:
      return 'time';
    case _fieldTypes.KBN_FIELD_TYPES.NUMBER:
      return 'linear';
  }
};
exports.getXScaleType = getXScaleType;
const getFieldType = schema => {
  if (schema === _common.NON_AGGREGATABLE) {
    return undefined;
  }
  let fieldType;
  switch (schema) {
    case 'datetime':
      fieldType = _fieldTypes.KBN_FIELD_TYPES.DATE;
      break;
    case 'numeric':
      fieldType = _fieldTypes.KBN_FIELD_TYPES.NUMBER;
      break;
    case 'boolean':
      fieldType = _fieldTypes.KBN_FIELD_TYPES.BOOLEAN;
      break;
    case 'json':
      fieldType = _fieldTypes.KBN_FIELD_TYPES.OBJECT;
      break;
    default:
      fieldType = _fieldTypes.KBN_FIELD_TYPES.STRING;
  }
  return fieldType;
};
exports.getFieldType = getFieldType;
const getLegendText = (chartData, maxChartColumns = MAX_CHART_COLUMNS) => {
  if (chartData.type === 'unsupported') {
    return _i18n.i18n.translate('xpack.ml.dataGridChart.histogramNotAvailable', {
      defaultMessage: 'Chart not supported.'
    });
  }
  if (chartData.data.length === 0) {
    return _i18n.i18n.translate('xpack.ml.dataGridChart.notEnoughData', {
      defaultMessage: `0 documents contain field.`
    });
  }
  if (chartData.type === 'boolean') {
    return /*#__PURE__*/_react.default.createElement("table", {
      css: cssHistogramLegendBoolean
    }, /*#__PURE__*/_react.default.createElement("tbody", null, /*#__PURE__*/_react.default.createElement("tr", null, chartData.data[0] !== undefined && /*#__PURE__*/_react.default.createElement("td", {
      css: cssTextAlignCenter
    }, chartData.data[0].key_as_string), chartData.data[1] !== undefined && /*#__PURE__*/_react.default.createElement("td", {
      css: cssTextAlignCenter
    }, chartData.data[1].key_as_string))));
  }
  if ((0, _field_histograms.isOrdinalChartData)(chartData) && chartData.cardinality <= maxChartColumns) {
    return _i18n.i18n.translate('xpack.ml.dataGridChart.singleCategoryLegend', {
      defaultMessage: `{cardinality, plural, one {# category} other {# categories}}`,
      values: {
        cardinality: chartData.cardinality
      }
    });
  }
  if ((0, _field_histograms.isOrdinalChartData)(chartData) && chartData.cardinality > maxChartColumns) {
    return _i18n.i18n.translate('xpack.ml.dataGridChart.topCategoriesLegend', {
      defaultMessage: `top {maxChartColumns} of {cardinality} categories`,
      values: {
        cardinality: chartData.cardinality,
        maxChartColumns
      }
    });
  }
  if ((0, _field_histograms.isNumericChartData)(chartData)) {
    const fromValue = Math.round(chartData.stats[0] * 100) / 100;
    const toValue = Math.round(chartData.stats[1] * 100) / 100;
    return fromValue !== toValue ? `${fromValue} - ${toValue}` : '' + fromValue;
  }
  return '';
};
exports.getLegendText = getLegendText;
const useColumnChart = (chartData, columnType, maxChartColumns) => {
  const fieldType = getFieldType(columnType.schema);
  const hoveredRow = (0, _useObservable.default)(hoveredRow$);
  const xScaleType = getXScaleType(fieldType);
  const getColor = d => {
    if (hoveredRow === undefined || hoveredRow === null) {
      return BAR_COLOR;
    }
    if ((0, _field_histograms.isOrdinalChartData)(chartData) && xScaleType === 'ordinal' && hoveredRow._source[columnType.id] === d.key) {
      return BAR_COLOR;
    }
    if ((0, _field_histograms.isNumericChartData)(chartData) && xScaleType === 'linear' && hoveredRow._source[columnType.id] >= +d.key && hoveredRow._source[columnType.id] < +d.key + chartData.interval) {
      return BAR_COLOR;
    }
    if ((0, _field_histograms.isNumericChartData)(chartData) && xScaleType === 'time' && (0, _moment.default)(hoveredRow._source[columnType.id]).unix() * 1000 >= +d.key && (0, _moment.default)(hoveredRow._source[columnType.id]).unix() * 1000 < +d.key + chartData.interval) {
      return BAR_COLOR;
    }
    return BAR_COLOR_BLUR;
  };
  let data = [];

  // The if/else if/else is a work-around because `.map()` doesn't work with union types.
  // See TS Caveats for details: https://www.typescriptlang.org/docs/handbook/release-notes/typescript-3-3.html#caveats
  if ((0, _field_histograms.isOrdinalChartData)(chartData)) {
    data = chartData.data.map(d => {
      var _d$key_as_string;
      return {
        ...d,
        key_as_string: (_d$key_as_string = d.key_as_string) !== null && _d$key_as_string !== void 0 ? _d$key_as_string : d.key,
        color: getColor(d)
      };
    });
  } else if ((0, _field_histograms.isNumericChartData)(chartData)) {
    data = chartData.data.map(d => ({
      ...d,
      key_as_string: d.key_as_string || d.key,
      color: getColor(d)
    }));
  }
  return {
    data,
    legendText: getLegendText(chartData, maxChartColumns),
    xScaleType
  };
};
exports.useColumnChart = useColumnChart;