"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataGridTitle = exports.DataGrid = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _field_histograms = require("../../../../common/constants/field_histograms");
var _common = require("../../data_frame_analytics/common");
var _common2 = require("./common");
var _decision_path_popover = require("../../data_frame_analytics/pages/analytics_exploration/components/feature_importance/decision_path_popover");
var _data_frame_analytics = require("../../../../common/constants/data_frame_analytics");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO Fix row hovering + bar highlighting
// import { hoveredRow$ } from './column_chart';

const cssOverride = (0, _react2.css)({
  '.euiDataGridRowCell--boolean': {
    textTransform: 'none'
  },
  // Overrides to align the sorting arrow, actions icon and the column header when no chart is available,
  // to the bottom of the cell when histogram charts are enabled.
  // Note that overrides have to be used as currently it is not possible to add a custom class name
  // for the EuiDataGridHeaderCell - see https://github.com/elastic/eui/issues/5106
  '.euiDataGridHeaderCell': {
    '.euiDataGridHeaderCell__sortingArrow,.euiDataGridHeaderCell__icon,.euiPopover': {
      marginTop: 'auto'
    }
  }
});
const DataGridTitle = ({
  title
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xs"
}, /*#__PURE__*/_react.default.createElement("span", null, title));
exports.DataGridTitle = DataGridTitle;
function isWithHeader(arg) {
  return typeof (arg === null || arg === void 0 ? void 0 : arg.title) === 'string' && (arg === null || arg === void 0 ? void 0 : arg.title) !== '';
}
const DataGrid = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    baseline,
    chartsVisible,
    chartsButtonVisible,
    ccsWarning,
    columnsWithCharts,
    dataTestSubj,
    errorMessage,
    invalidSortingColumnns,
    noDataMessage,
    onChangeItemsPerPage,
    onChangePage,
    onSort,
    pagination,
    setVisibleColumns,
    renderCellValue,
    rowCount,
    sortingColumns,
    status,
    tableItems: data,
    toastNotifications,
    toggleChartVisibility,
    visibleColumns,
    predictionFieldName,
    resultsField,
    analysisType,
    trailingControlColumns
  } = props;
  // TODO Fix row hovering + bar highlighting
  // const getRowProps = (item: any) => {
  //   return {
  //     onMouseOver: () => hoveredRow$.next(item),
  //     onMouseLeave: () => hoveredRow$.next(null),
  //   };
  // };

  const renderCellPopover = (0, _react.useCallback)(popoverProps => {
    const {
      schema,
      rowIndex,
      cellContentsElement,
      DefaultCellPopover
    } = popoverProps;
    if (analysisType === _common.ANALYSIS_CONFIG_TYPE.REGRESSION || analysisType === _common.ANALYSIS_CONFIG_TYPE.CLASSIFICATION || analysisType === _common.ANALYSIS_CONFIG_TYPE.OUTLIER_DETECTION) {
      if (schema === 'featureImportance') {
        const row = data[rowIndex - pagination.pageIndex * pagination.pageSize];
        if (!row) return /*#__PURE__*/_react.default.createElement("div", null);
        // if resultsField for some reason is not available then use ml
        const mlResultsField = resultsField !== null && resultsField !== void 0 ? resultsField : _data_frame_analytics.DEFAULT_RESULTS_FIELD;
        let predictedValue;
        let predictedProbability;
        let topClasses = [];
        if (predictionFieldName !== undefined && row && row[`${mlResultsField}.${predictionFieldName}`] !== undefined) {
          predictedValue = row[`${mlResultsField}.${predictionFieldName}`];
          topClasses = (0, _common2.getTopClasses)(row, mlResultsField);
          predictedProbability = row[`${mlResultsField}.prediction_probability`];
        }
        const isClassTypeBoolean = topClasses.reduce((p, c) => typeof c.class_name === 'boolean' || p, false);
        const parsedFIArray = (0, _common2.getFeatureImportance)(row, mlResultsField, isClassTypeBoolean);
        return /*#__PURE__*/_react.default.createElement("div", {
          "data-test-subj": "mlDFAFeatureImportancePopover"
        }, /*#__PURE__*/_react.default.createElement(_decision_path_popover.DecisionPathPopover, {
          analysisType: analysisType,
          predictedValue: predictedValue,
          predictedProbability: predictedProbability,
          baseline: baseline,
          featureImportance: parsedFIArray,
          topClasses: topClasses,
          predictionFieldName: predictionFieldName ? predictionFieldName.replace('_prediction', '') : undefined
        }));
      } else if (schema === 'featureInfluence') {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
          isCopyable: true
        }, cellContentsElement.textContent);
      } else {
        return /*#__PURE__*/_react.default.createElement(DefaultCellPopover, popoverProps);
      }
    } else {
      return /*#__PURE__*/_react.default.createElement(DefaultCellPopover, popoverProps);
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [baseline, data]);
  (0, _react.useEffect)(() => {
    if (invalidSortingColumnns.length > 0) {
      invalidSortingColumnns.forEach(columnId => {
        toastNotifications.addDanger(_i18n.i18n.translate('xpack.ml.dataGrid.invalidSortingColumnError', {
          defaultMessage: `The column '{columnId}' cannot be used for sorting.`,
          values: {
            columnId
          }
        }));
      });
    }
  }, [invalidSortingColumnns, toastNotifications]);
  const wrapperEl = (0, _react.useRef)(null);
  if (status === _common.INDEX_STATUS.LOADED && data.length === 0) {
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": `${dataTestSubj} empty`
    }, isWithHeader(props) && /*#__PURE__*/_react.default.createElement(DataGridTitle, {
      title: props.title
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.ml.dataGrid.IndexNoDataCalloutTitle', {
        defaultMessage: 'Empty index query result.'
      }),
      color: "primary"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.ml.dataGrid.IndexNoDataCalloutBody', {
      defaultMessage: 'The query for the index returned no results. Please make sure you have sufficient permissions, the index contains documents and your query is not too restrictive.'
    }))));
  }
  if (noDataMessage !== '') {
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": `${dataTestSubj} empty`
    }, isWithHeader(props) && /*#__PURE__*/_react.default.createElement(DataGridTitle, {
      title: props.title
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.ml.dataGrid.dataGridNoDataCalloutTitle', {
        defaultMessage: 'Index preview not available'
      }),
      color: "primary"
    }, /*#__PURE__*/_react.default.createElement("p", null, noDataMessage)));
  }
  let errorCallout;
  if (status === _common.INDEX_STATUS.ERROR) {
    // if it's a searchBar syntax error leave the table visible so they can try again
    if (errorMessage && !errorMessage.includes('failed to create query')) {
      errorCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.exploration.querySyntaxError', {
          defaultMessage: 'An error occurred loading the index data. Please ensure your query syntax is valid.'
        }),
        color: "danger",
        iconType: "cross"
      }, /*#__PURE__*/_react.default.createElement("p", null, errorMessage));
    } else {
      errorCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: _i18n.i18n.translate('xpack.ml.dataGrid.indexDataError', {
          defaultMessage: 'An error occurred loading the index data.'
        }),
        color: "danger",
        iconType: "cross"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        language: "json",
        fontSize: "s",
        paddingSize: "s",
        isCopyable: true
      }, errorMessage));
    }
  }
  const onMutation = () => {
    if (wrapperEl.current !== null) {
      const els = wrapperEl.current.querySelectorAll('.euiDataGrid__virtualized');
      for (const el of Array.from(els)) {
        if ((0, _mlIsPopulatedObject.isPopulatedObject)(el) && (0, _mlIsPopulatedObject.isPopulatedObject)(el.style) && el.style.height !== 'auto') {
          el.style.height = 'auto';
        }
      }
    }
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `${dataTestSubj} ${status === _common.INDEX_STATUS.ERROR ? 'error' : 'loaded'}`,
    ref: wrapperEl
  }, isWithHeader(props) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(DataGridTitle, {
    title: props.title
  })), props.copyToClipboard && props.copyToClipboardDescription && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    beforeMessage: props.copyToClipboardDescription,
    textToCopy: props.copyToClipboard
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: copy,
    iconType: "copyClipboard",
    "aria-label": props.copyToClipboardDescription
  })))), errorCallout !== undefined && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `${dataTestSubj} error`
  }, errorCallout, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), ccsWarning && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `${dataTestSubj} ccsWarning`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.ml.dataGrid.CcsWarningCalloutTitle', {
      defaultMessage: 'Cross-cluster search returned no fields data.'
    }),
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.ml.dataGrid.CcsWarningCalloutBody', {
    defaultMessage: 'There was an issue retrieving data for the data view. Source preview in combination with cross-cluster search is only supported for versions 7.10 and above. You may still configure and create the transform.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), rowCount > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiMutationObserver, {
    observerOptions: {
      subtree: true,
      attributes: true,
      childList: true
    },
    onMutation: onMutation
  }, mutationRef => /*#__PURE__*/_react.default.createElement("div", {
    css: cssOverride,
    ref: mutationRef
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDataGrid, {
    "aria-label": isWithHeader(props) ? props.title : '',
    columns: columnsWithCharts.map(c => {
      c.initialWidth = 165;
      return c;
    }),
    columnVisibility: {
      visibleColumns,
      setVisibleColumns
    },
    trailingControlColumns: trailingControlColumns,
    gridStyle: _common2.euiDataGridStyle,
    rowCount: rowCount,
    renderCellValue: renderCellValue,
    renderCellPopover: renderCellPopover,
    sorting: {
      columns: sortingColumns,
      onSort
    },
    toolbarVisibility: {
      ..._common2.euiDataGridToolbarSettings,
      ...(chartsButtonVisible ? {
        additionalControls: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: _i18n.i18n.translate('xpack.ml.dataGrid.histogramButtonToolTipContent', {
            defaultMessage: 'Queries run to fetch histogram chart data will use a sample size per shard of {samplerShardSize} documents.',
            values: {
              samplerShardSize: _field_histograms.DEFAULT_SAMPLER_SHARD_SIZE
            }
          })
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
          "aria-pressed": chartsVisible === true,
          className: `euiDataGrid__controlBtn${chartsVisible === true ? ' euiDataGrid__controlBtn--active' : ''}`,
          "data-test-subj": `${dataTestSubj}HistogramButton`,
          size: "xs",
          iconType: "visBarVertical",
          color: "text",
          onClick: toggleChartVisibility,
          disabled: chartsVisible === undefined
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.dataGrid.histogramButtonText",
          defaultMessage: "Histogram charts"
        })))
      } : {})
    },
    pagination: {
      ...pagination,
      pageSizeOptions: [5, 10, 25],
      onChangeItemsPerPage,
      onChangePage
    }
  }))));
}, (prevProps, nextProps) => (0, _lodash.isEqual)(pickProps(prevProps), pickProps(nextProps)));
exports.DataGrid = DataGrid;
function pickProps(props) {
  return [props.columnsWithCharts, props.dataTestSubj, props.errorMessage, props.invalidSortingColumnns, props.noDataMessage, props.pagination, props.rowCount, props.sortingColumns, props.status, props.tableItems, props.visibleColumns, ...(isWithHeader(props) ? [props.copyToClipboard, props.copyToClipboardDescription, props.title] : [])];
}