"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiDataGridToolbarSettings = exports.euiDataGridStyle = exports.NON_AGGREGATABLE = exports.INIT_MAX_COLUMNS = exports.COLUMN_CHART_DEFAULT_VISIBILITY_ROWS_THRESHOLD = void 0;
exports.getCombinedRuntimeMappings = getCombinedRuntimeMappings;
exports.useRenderCellValue = exports.showDataGridColumnChartErrorMessageToast = exports.multiColumnSortFactory = exports.getTopClasses = exports.getProcessedFields = exports.getNestedOrEscapedVal = exports.getFieldsFromKibanaIndexPattern = exports.getFeatureImportance = exports.getDataGridSchemasFromFieldTypes = exports.getDataGridSchemaFromKibanaFieldType = exports.getDataGridSchemaFromESFieldType = void 0;
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _fieldTypes = require("@kbn/field-types");
var _mlNestedProperty = require("@kbn/ml-nested-property");
var _mlAggUtils = require("@kbn/ml-agg-utils");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _data_frame_analytics = require("../../../../common/constants/data_frame_analytics");
var _fields = require("../../data_frame_analytics/common/fields");
var _constants = require("../../data_frame_analytics/common/constants");
var _date_utils = require("../../../../common/util/date_utils");
var _field_format_service = require("../../services/field_format_service");
var _runtime_field_utils = require("../../../../common/util/runtime_field_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INIT_MAX_COLUMNS = 10;
exports.INIT_MAX_COLUMNS = INIT_MAX_COLUMNS;
const COLUMN_CHART_DEFAULT_VISIBILITY_ROWS_THRESHOLD = 10000;
exports.COLUMN_CHART_DEFAULT_VISIBILITY_ROWS_THRESHOLD = COLUMN_CHART_DEFAULT_VISIBILITY_ROWS_THRESHOLD;
const euiDataGridStyle = {
  border: 'all',
  fontSize: 's',
  cellPadding: 's',
  stripes: false,
  rowHover: 'none',
  header: 'shade'
};
exports.euiDataGridStyle = euiDataGridStyle;
const euiDataGridToolbarSettings = {
  showColumnSelector: true,
  showDisplaySelector: false,
  showSortSelector: true,
  showFullScreenSelector: false
};
exports.euiDataGridToolbarSettings = euiDataGridToolbarSettings;
const getFieldsFromKibanaIndexPattern = indexPattern => {
  const allFields = indexPattern.fields.map(f => f.name);
  const indexPatternFields = allFields.filter(f => {
    if (indexPattern.metaFields.includes(f)) {
      return false;
    }
    const fieldParts = f.split('.');
    const lastPart = fieldParts.pop();
    if (lastPart === 'keyword' && allFields.includes(fieldParts.join('.'))) {
      return false;
    }
    return true;
  });
  return indexPatternFields;
};

/**
 * Return a map of runtime_mappings for each of the index pattern field provided
 * to provide in ES search queries
 * @param indexPattern
 * @param RuntimeMappings
 */
exports.getFieldsFromKibanaIndexPattern = getFieldsFromKibanaIndexPattern;
function getCombinedRuntimeMappings(indexPattern, runtimeMappings) {
  let combinedRuntimeMappings = {};

  // Add runtime field mappings defined by index pattern
  if (indexPattern) {
    const computedFields = indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.getComputedFields();
    if ((computedFields === null || computedFields === void 0 ? void 0 : computedFields.runtimeFields) !== undefined) {
      const indexPatternRuntimeMappings = computedFields.runtimeFields;
      if ((0, _runtime_field_utils.isRuntimeMappings)(indexPatternRuntimeMappings)) {
        combinedRuntimeMappings = {
          ...combinedRuntimeMappings,
          ...indexPatternRuntimeMappings
        };
      }
    }
  }

  // Use runtime field mappings defined inline from API
  // and override fields with same name from index pattern
  if ((0, _runtime_field_utils.isRuntimeMappings)(runtimeMappings)) {
    combinedRuntimeMappings = {
      ...combinedRuntimeMappings,
      ...runtimeMappings
    };
  }
  if ((0, _runtime_field_utils.isRuntimeMappings)(combinedRuntimeMappings)) {
    return combinedRuntimeMappings;
  }
}
const getDataGridSchemasFromFieldTypes = (fieldTypes, resultsField) => {
  return Object.keys(fieldTypes).map(field => {
    // Built-in values are ['boolean', 'currency', 'datetime', 'numeric', 'json']
    // To fall back to the default string schema it needs to be undefined.
    let schema;
    const isSortable = true;
    const type = fieldTypes[field];
    const isNumber = type !== undefined && (_fields.BASIC_NUMERICAL_TYPES.has(type) || _fields.EXTENDED_NUMERICAL_TYPES.has(type));
    if (isNumber) {
      schema = 'numeric';
    }
    switch (type) {
      case 'date':
        schema = 'datetime';
        break;
      case 'nested':
      case 'geo_point':
        schema = 'json';
        break;
      case 'boolean':
        schema = 'boolean';
        break;
      case 'text':
        schema = NON_AGGREGATABLE;
    }
    if (field === `${resultsField}.${_constants.OUTLIER_SCORE}`) {
      schema = 'numeric';
    }
    if (field.includes(`${resultsField}.${_constants.TOP_CLASSES}`)) {
      schema = 'json';
    }
    if (field.includes(`${resultsField}.${_constants.FEATURE_IMPORTANCE}`)) {
      schema = 'featureImportance';
    }
    if (field === `${resultsField}.${_constants.FEATURE_INFLUENCE}`) {
      schema = 'featureInfluence';
    }
    return {
      id: field,
      schema,
      isSortable
    };
  });
};
exports.getDataGridSchemasFromFieldTypes = getDataGridSchemasFromFieldTypes;
const NON_AGGREGATABLE = 'non-aggregatable';
exports.NON_AGGREGATABLE = NON_AGGREGATABLE;
const getDataGridSchemaFromESFieldType = fieldType => {
  // Built-in values are ['boolean', 'currency', 'datetime', 'numeric', 'json']
  // To fall back to the default string schema it needs to be undefined.
  let schema;
  switch (fieldType) {
    case _fieldTypes.ES_FIELD_TYPES.GEO_POINT:
    case _fieldTypes.ES_FIELD_TYPES.GEO_SHAPE:
      schema = 'json';
      break;
    case _fieldTypes.ES_FIELD_TYPES.BOOLEAN:
      schema = 'boolean';
      break;
    case _fieldTypes.ES_FIELD_TYPES.DATE:
    case _fieldTypes.ES_FIELD_TYPES.DATE_NANOS:
      schema = 'datetime';
      break;
    case _fieldTypes.ES_FIELD_TYPES.BYTE:
    case _fieldTypes.ES_FIELD_TYPES.DOUBLE:
    case _fieldTypes.ES_FIELD_TYPES.FLOAT:
    case _fieldTypes.ES_FIELD_TYPES.HALF_FLOAT:
    case _fieldTypes.ES_FIELD_TYPES.INTEGER:
    case _fieldTypes.ES_FIELD_TYPES.LONG:
    case _fieldTypes.ES_FIELD_TYPES.SCALED_FLOAT:
    case _fieldTypes.ES_FIELD_TYPES.SHORT:
    case 'number':
      schema = 'numeric';
      break;
    // keep schema undefined for text based columns
    case _fieldTypes.ES_FIELD_TYPES.KEYWORD:
    case _fieldTypes.ES_FIELD_TYPES.VERSION:
    case _fieldTypes.ES_FIELD_TYPES.TEXT:
      break;
  }
  return schema;
};
exports.getDataGridSchemaFromESFieldType = getDataGridSchemaFromESFieldType;
const getDataGridSchemaFromKibanaFieldType = field => {
  var _field$esTypes;
  // Built-in values are ['boolean', 'currency', 'datetime', 'numeric', 'json']
  // To fall back to the default string schema it needs to be undefined.
  let schema;
  if (!field) return;
  switch (field.type) {
    case _fieldTypes.KBN_FIELD_TYPES.BOOLEAN:
      schema = 'boolean';
      break;
    case _fieldTypes.KBN_FIELD_TYPES.DATE:
      schema = 'datetime';
      break;
    case _fieldTypes.KBN_FIELD_TYPES.GEO_POINT:
    case _fieldTypes.KBN_FIELD_TYPES.GEO_SHAPE:
      schema = 'json';
      break;
    case _fieldTypes.KBN_FIELD_TYPES.NUMBER:
      schema = 'numeric';
      break;
    case _fieldTypes.KBN_FIELD_TYPES.NESTED:
      schema = 'json';
      break;
  }
  if (schema === undefined && field.aggregatable === false || (0, _mlAggUtils.isCounterTimeSeriesMetric)(field) || schema === 'numeric' && field !== null && field !== void 0 && (_field$esTypes = field.esTypes) !== null && _field$esTypes !== void 0 && _field$esTypes.some(d => d === _fieldTypes.ES_FIELD_TYPES.AGGREGATE_METRIC_DOUBLE)) {
    return NON_AGGREGATABLE;
  }
  return schema;
};
exports.getDataGridSchemaFromKibanaFieldType = getDataGridSchemaFromKibanaFieldType;
const getClassName = (className, isClassTypeBoolean) => {
  if (isClassTypeBoolean) {
    return className === 'true';
  }
  return className;
};

/**
 * Helper to transform feature importance fields with arrays back to primitive value
 *
 * @param row - EUI data grid data row
 * @param mlResultsField - Data frame analytics results field
 * @returns nested object structure of feature importance values
 */
const getFeatureImportance = (row, mlResultsField, isClassTypeBoolean = false) => {
  const featureImportance = row[`${mlResultsField}.feature_importance`];
  if (featureImportance === undefined) return [];
  return featureImportance.map(fi => ({
    feature_name: Array.isArray(fi.feature_name) ? fi.feature_name[0] : fi.feature_name,
    classes: Array.isArray(fi.classes) ? fi.classes.map(c => {
      const processedClass = getProcessedFields(c);
      return {
        importance: processedClass.importance,
        class_name: getClassName(processedClass.class_name, isClassTypeBoolean)
      };
    }) : fi.classes,
    importance: Array.isArray(fi.importance) ? fi.importance[0] : fi.importance
  }));
};

/**
 * Helper to transforms top classes fields with arrays back to original primitive value
 *
 * @param row - EUI data grid data row
 * @param mlResultsField - Data frame analytics results field
 * @returns nested object structure of feature importance values
 */
exports.getFeatureImportance = getFeatureImportance;
const getTopClasses = (row, mlResultsField) => {
  const topClasses = row[`${mlResultsField}.top_classes`];
  if (topClasses === undefined) return [];
  return topClasses.map(tc => getProcessedFields(tc));
};
exports.getTopClasses = getTopClasses;
const useRenderCellValue = (indexPattern, pagination, tableItems, resultsField, cellPropsCallback) => {
  const renderCellValue = (0, _react.useMemo)(() => {
    return ({
      rowIndex,
      columnId,
      setCellProps
    }) => {
      const adjustedRowIndex = rowIndex - pagination.pageIndex * pagination.pageSize;
      const fullItem = tableItems[adjustedRowIndex];
      if (fullItem === undefined) {
        return null;
      }
      if (indexPattern === undefined) {
        return null;
      }
      let format;
      if (indexPattern !== undefined) {
        format = _field_format_service.mlFieldFormatService.getFieldFormatFromIndexPattern(indexPattern, columnId, '');
      }
      function getCellValue(cId) {
        if (tableItems.hasOwnProperty(adjustedRowIndex)) {
          const item = tableItems[adjustedRowIndex];

          // Try if the field name is available as is.
          if (item.hasOwnProperty(cId)) {
            return item[cId];
          }

          // For classification and regression results, we need to treat some fields with a custom transform.
          if (cId === `${resultsField}.feature_importance`) {
            return getFeatureImportance(fullItem, resultsField !== null && resultsField !== void 0 ? resultsField : _data_frame_analytics.DEFAULT_RESULTS_FIELD);
          }
          if (cId === `${resultsField}.top_classes`) {
            return getTopClasses(fullItem, resultsField !== null && resultsField !== void 0 ? resultsField : _data_frame_analytics.DEFAULT_RESULTS_FIELD);
          }

          // Try if the field name is available as a nested field.
          return (0, _mlNestedProperty.getNestedProperty)(tableItems[adjustedRowIndex], cId, null);
        }
        return null;
      }
      const cellValue = getCellValue(columnId);
      if (typeof cellPropsCallback === 'function') {
        cellPropsCallback(columnId, cellValue, fullItem, setCellProps);
      }
      if (typeof cellValue === 'object' && cellValue !== null) {
        return JSON.stringify(cellValue);
      }
      if (cellValue === undefined || cellValue === null) {
        return null;
      }
      if (format !== undefined) {
        return format.convert(cellValue, 'text');
      }
      if (typeof cellValue === 'string' || cellValue === null) {
        return cellValue;
      }
      const field = indexPattern.fields.getByName(columnId);
      if ((field === null || field === void 0 ? void 0 : field.type) === _fieldTypes.KBN_FIELD_TYPES.DATE) {
        return (0, _date_utils.formatHumanReadableDateTimeSeconds)((0, _momentTimezone.default)(cellValue).unix() * 1000);
      }
      if (typeof cellValue === 'boolean') {
        return cellValue ? 'true' : 'false';
      }
      return cellValue;
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.fields, pagination.pageIndex, pagination.pageSize, tableItems]);
  return renderCellValue;
};

// Value can be nested or the fieldName itself might contain other special characters like `.`
exports.useRenderCellValue = useRenderCellValue;
const getNestedOrEscapedVal = (obj, sortId) => {
  var _getNestedProperty;
  return (_getNestedProperty = (0, _mlNestedProperty.getNestedProperty)(obj, sortId, null)) !== null && _getNestedProperty !== void 0 ? _getNestedProperty : obj[sortId];
};
exports.getNestedOrEscapedVal = getNestedOrEscapedVal;
/**
 * Helper to sort an array of objects based on an EuiDataGrid sorting configuration.
 * `sortFn()` is recursive to support sorting on multiple columns.
 *
 * @param sortingColumns - The EUI data grid sorting configuration
 * @returns The sorting function which can be used with an array's sort() function.
 */
const multiColumnSortFactory = sortingColumns => {
  const sortFn = (a, b, sortingColumnIndex = 0) => {
    const sort = sortingColumns[sortingColumnIndex];

    // Value can be nested or the fieldName itself might contain `.`
    let aValue = getNestedOrEscapedVal(a, sort.id);
    let bValue = getNestedOrEscapedVal(b, sort.id);
    if (sort.type === 'number') {
      var _aValue, _bValue;
      aValue = (_aValue = aValue) !== null && _aValue !== void 0 ? _aValue : 0;
      bValue = (_bValue = bValue) !== null && _bValue !== void 0 ? _bValue : 0;
      if (aValue < bValue) {
        return sort.direction === 'asc' ? -1 : 1;
      }
      if (aValue > bValue) {
        return sort.direction === 'asc' ? 1 : -1;
      }
    }
    if (sort.type === 'string') {
      var _aValue2, _bValue2;
      aValue = (_aValue2 = aValue) !== null && _aValue2 !== void 0 ? _aValue2 : '';
      bValue = (_bValue2 = bValue) !== null && _bValue2 !== void 0 ? _bValue2 : '';
      if (aValue.localeCompare(bValue) === -1) {
        return sort.direction === 'asc' ? -1 : 1;
      }
      if (aValue.localeCompare(bValue) === 1) {
        return sort.direction === 'asc' ? 1 : -1;
      }
    }
    if (sortingColumnIndex + 1 < sortingColumns.length) {
      return sortFn(a, b, sortingColumnIndex + 1);
    }
    return 0;
  };
  return sortFn;
};
exports.multiColumnSortFactory = multiColumnSortFactory;
const showDataGridColumnChartErrorMessageToast = (e, toastNotifications) => {
  const error = (0, _mlErrorUtils.extractErrorMessage)(e);
  toastNotifications.addDanger(_i18n.i18n.translate('xpack.ml.dataGrid.columnChart.ErrorMessageToast', {
    defaultMessage: 'An error occurred fetching the histogram charts data: {error}',
    values: {
      error: error !== '' ? error : e
    }
  }));
};

// helper function to transform { [key]: [val] } => { [key]: val }
// for when `fields` is used in es.search since response is always an array of values
// since response always returns an array of values for each field
exports.showDataGridColumnChartErrorMessageToast = showDataGridColumnChartErrorMessageToast;
const getProcessedFields = (originalObj, omitBy) => {
  const obj = {
    ...originalObj
  };
  for (const key of Object.keys(obj)) {
    // if no conditional is included, process everything
    if (omitBy === undefined) {
      if (Array.isArray(obj[key]) && obj[key].length === 1) {
        obj[key] = obj[key][0];
      }
    } else {
      // else only process the fields for things users don't want to omit
      if (omitBy(key) === false) if (Array.isArray(obj[key]) && obj[key].length === 1) {
        obj[key] = obj[key][0];
      }
    }
  }
  return obj;
};
exports.getProcessedFields = getProcessedFields;